/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationComboBox;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.CloudProjectIdLabel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.base.Predicate;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.run.AvdComboBox;
import org.jetbrains.android.run.ConfigurationSpecificEditor;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private final Project myProject;
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private ModulesComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private JCheckBox myWipeUserDataCheckBox;
    private JComboBox myNetworkSpeedCombo;
    private JComboBox myNetworkLatencyCombo;
    private JCheckBox myDisableBootAnimationCombo;
    private JCheckBox myClearLogCheckBox;
    private JBLabel myModuleJBLabel;
    private JRadioButton myShowChooserRadioButton;
    private JRadioButton myEmulatorRadioButton;
    private JRadioButton myUsbDeviceRadioButton;
    private ComboboxWithBrowseButton myAvdComboComponent;
    private JBLabel myMinSdkInfoMessageLabel;
    private JBCheckBox myUseAdditionalCommandLineOptionsCheckBox;
    private RawCommandLineEditor myCommandLineField;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox myFilterLogcatCheckBox;
    private JCheckBox myUseLastSelectedDeviceCheckBox;
    private JRadioButton myRunTestsInGoogleCloudRadioButton;
    private CloudConfigurationComboBox myCloudMatrixConfigurationCombo;
    private JBLabel myCloudMatrixProjectLabel;
    private JBLabel myCloudMatrixConfigLabel;
    private CloudProjectIdLabel myCloudMatrixProjectIdLabel;
    private ActionButton myCloudMatrixProjectIdUpdateButton;
    private JRadioButton myLaunchCloudDeviceRadioButton;
    private JBLabel myCloudDeviceConfigLabel;
    private JBLabel myCloudDeviceProjectLabel;
    private CloudProjectIdLabel myCloudDeviceProjectIdLabel;
    private ActionButton myCloudDeviceProjectIdUpdateButton;
    private CloudConfigurationComboBox myCloudDeviceConfigurationCombo;
    @Nullable
    private final CloudConfigurationProvider myCloudConfigurationProvider;
    private AvdComboBox myAvdCombo;
    private String incorrectPreferredAvd;
    private JComponent anchor;
    @NonNls
    private static final String[] NETWORK_SPEEDS = new String[]{"Full", "GSM", "HSCSD", "GPRS", "EDGE", "UMTS", "HSPDA"};
    @NonNls
    private static final String[] NETWORK_LATENCIES = new String[]{"None", "GPRS", "EDGE", "UMTS"};
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;

    public void setConfigurationSpecificEditor(ConfigurationSpecificEditor<T> configurationSpecificEditor) {
        this.myConfigurationSpecificEditor = configurationSpecificEditor;
        this.myConfigurationSpecificPanel.add(configurationSpecificEditor.getComponent());
        this.setAnchor(this.myConfigurationSpecificEditor.getAnchor());
        this.myShowLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
        this.myFilterLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
    }

    public AndroidRunConfigurationEditor(Project project, final Predicate<AndroidFacet> libraryProjectValidator) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCloudConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.myCommandLineField.setDialogCaption("Emulator Additional Command Line Options");
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) {
                    return false;
                }
                return !facet.isLibraryProject() || libraryProjectValidator.apply((Object)facet);
            }
        };
        this.myAvdCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String warning = AndroidRunConfigurationEditor.this.myEmulatorRadioButton.isSelected() ? AndroidRunConfigurationEditor.this.getAvdCompatibilityWarning() : null;
                AndroidRunConfigurationEditor.this.resetAvdCompatibilityWarningLabel(warning);
            }
        });
        this.myMinSdkInfoMessageLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.myMinSdkInfoMessageLabel.setIcon(AllIcons.General.BalloonWarning);
        Disposer.register((Disposable)this, (Disposable)this.myAvdCombo);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidRunConfigurationEditor.this.updateEnabled();
            }
        };
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidFacet facet;
                Module module = AndroidRunConfigurationEditor.this.getModuleSelector().getModule();
                AndroidFacet androidFacet = facet = module != null ? AndroidFacet.getInstance(module) : null;
                if (facet == null) {
                    AndroidRunConfigurationEditor.this.updateCloudMatrixTestEnabled(false);
                    AndroidRunConfigurationEditor.this.updateCloudDeviceLaunchEnabled(false);
                } else {
                    AndroidRunConfigurationEditor.this.myCloudMatrixProjectIdLabel.setFacet(facet);
                    AndroidRunConfigurationEditor.this.myCloudMatrixConfigurationCombo.setFacet(facet);
                    AndroidRunConfigurationEditor.this.myCloudDeviceProjectIdLabel.setFacet(facet);
                    AndroidRunConfigurationEditor.this.myCloudDeviceConfigurationCombo.setFacet(facet);
                    AndroidRunConfigurationEditor.this.updateCloudMatrixTestEnabled(AndroidRunConfigurationEditor.this.myRunTestsInGoogleCloudRadioButton.isSelected());
                    AndroidRunConfigurationEditor.this.updateCloudDeviceLaunchEnabled(AndroidRunConfigurationEditor.this.myLaunchCloudDeviceRadioButton.isSelected());
                }
                AndroidRunConfigurationEditor.this.myAvdCombo.startUpdatingAvds(ModalityState.current());
            }
        });
        this.myShowChooserRadioButton.addActionListener(listener);
        this.myEmulatorRadioButton.addActionListener(listener);
        this.myUsbDeviceRadioButton.addActionListener(listener);
        this.myUseLastSelectedDeviceCheckBox.addActionListener(listener);
        this.myRunTestsInGoogleCloudRadioButton.addActionListener(listener);
        this.myLaunchCloudDeviceRadioButton.addActionListener(listener);
        this.myNetworkSpeedCombo.setModel(new DefaultComboBoxModel<String>(NETWORK_SPEEDS));
        this.myNetworkLatencyCombo.setModel(new DefaultComboBoxModel<String>(NETWORK_LATENCIES));
        this.myUseAdditionalCommandLineOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidRunConfigurationEditor.this.myCommandLineField.setEnabled(AndroidRunConfigurationEditor.this.myUseAdditionalCommandLineOptionsCheckBox.isSelected());
            }
        });
        this.updateEnabled();
    }

    private void createUIComponents() {
        this.myAvdCombo = new AvdComboBox(this.myProject, true, false){

            @Override
            public Module getModule() {
                return AndroidRunConfigurationEditor.this.getModuleSelector().getModule();
            }
        };
        this.myAvdCombo.getComboBox().setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof IdDisplay) {
                    this.setText(((IdDisplay)value).getDisplay());
                } else {
                    this.setText(String.format("<html><font color='red'>Unknown AVD %1$s</font></html>", value == null ? "" : value.toString()));
                }
            }
        });
        this.myAvdComboComponent = new ComboboxWithBrowseButton(this.myAvdCombo.getComboBox());
        this.myCloudMatrixProjectIdLabel = new CloudProjectIdLabel(CloudConfiguration.Kind.MATRIX);
        this.myCloudMatrixConfigurationCombo = new CloudConfigurationComboBox(CloudConfiguration.Kind.MATRIX);
        SelectCloudProjectAction cloudMatrixProjectAction = new SelectCloudProjectAction(this.myCloudMatrixProjectIdLabel, this.myCloudMatrixConfigurationCombo);
        this.myCloudMatrixProjectIdUpdateButton = new ActionButton((AnAction)cloudMatrixProjectAction, new PresentationFactory().getPresentation((AnAction)cloudMatrixProjectAction), "MyPlace", new Dimension(25, 25));
        Disposer.register((Disposable)this, (Disposable)this.myCloudMatrixConfigurationCombo);
        this.myCloudDeviceProjectIdLabel = new CloudProjectIdLabel(CloudConfiguration.Kind.SINGLE_DEVICE);
        this.myCloudDeviceConfigurationCombo = new CloudConfigurationComboBox(CloudConfiguration.Kind.SINGLE_DEVICE);
        SelectCloudProjectAction cloudDeviceProjectAction = new SelectCloudProjectAction(this.myCloudDeviceProjectIdLabel, this.myCloudDeviceConfigurationCombo);
        this.myCloudDeviceProjectIdUpdateButton = new ActionButton((AnAction)cloudDeviceProjectAction, new PresentationFactory().getPresentation((AnAction)cloudDeviceProjectAction), "MyPlace", new Dimension(25, 25));
        Disposer.register((Disposable)this, (Disposable)this.myCloudDeviceConfigurationCombo);
    }

    private void updateGoogleCloudVisible(AndroidRunConfigurationBase configuration) {
        boolean shouldShowCloudDevice = CloudConfigurationProvider.isEnabled();
        this.myLaunchCloudDeviceRadioButton.setVisible(shouldShowCloudDevice);
        this.myCloudDeviceConfigurationCombo.setVisible(shouldShowCloudDevice);
        this.myCloudDeviceProjectLabel.setVisible(shouldShowCloudDevice);
        this.myCloudDeviceConfigLabel.setVisible(shouldShowCloudDevice);
        this.myCloudDeviceProjectIdLabel.setVisible(shouldShowCloudDevice);
        this.myCloudDeviceProjectIdUpdateButton.setVisible(shouldShowCloudDevice);
        boolean shouldShowCloudMatrix = configuration instanceof AndroidTestRunConfiguration && shouldShowCloudDevice;
        this.myRunTestsInGoogleCloudRadioButton.setVisible(shouldShowCloudMatrix);
        this.myCloudMatrixConfigurationCombo.setVisible(shouldShowCloudMatrix);
        this.myCloudMatrixProjectLabel.setVisible(shouldShowCloudMatrix);
        this.myCloudMatrixConfigLabel.setVisible(shouldShowCloudMatrix);
        this.myCloudMatrixProjectIdLabel.setVisible(shouldShowCloudMatrix);
        this.myCloudMatrixProjectIdUpdateButton.setVisible(shouldShowCloudMatrix);
    }

    private void updateEnabled() {
        boolean emulatorSelected = this.myEmulatorRadioButton.isSelected();
        this.myAvdComboComponent.setEnabled(emulatorSelected);
        this.updateCloudMatrixTestEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.updateCloudDeviceLaunchEnabled(this.myLaunchCloudDeviceRadioButton.isSelected());
        String warning = emulatorSelected ? this.getAvdCompatibilityWarning() : null;
        this.resetAvdCompatibilityWarningLabel(warning);
    }

    private void updateCloudMatrixTestEnabled(boolean isEnabled) {
        this.myCloudMatrixConfigurationCombo.setEnabled(isEnabled);
        this.myCloudMatrixProjectLabel.setEnabled(isEnabled);
        this.myCloudMatrixConfigLabel.setEnabled(isEnabled);
        this.myCloudMatrixProjectIdLabel.setEnabled(isEnabled);
        this.myCloudMatrixProjectIdUpdateButton.setEnabled(isEnabled);
    }

    private void updateCloudDeviceLaunchEnabled(boolean isEnabled) {
        this.myCloudDeviceConfigurationCombo.setEnabled(isEnabled);
        this.myCloudDeviceProjectLabel.setEnabled(isEnabled);
        this.myCloudDeviceConfigLabel.setEnabled(isEnabled);
        this.myCloudDeviceProjectIdLabel.setEnabled(isEnabled);
        this.myCloudDeviceProjectIdUpdateButton.setEnabled(isEnabled);
    }

    private void resetAvdCompatibilityWarningLabel(@Nullable String warning) {
        if (warning != null) {
            this.myMinSdkInfoMessageLabel.setVisible(true);
            this.myMinSdkInfoMessageLabel.setText(warning);
        } else {
            this.myMinSdkInfoMessageLabel.setVisible(false);
        }
    }

    private CloudConfiguration getCloudConfigurationComboSelection(CloudConfiguration.Kind configurationKind) {
        if (configurationKind == CloudConfiguration.Kind.MATRIX) {
            return (CloudConfiguration)this.myCloudMatrixConfigurationCombo.getComboBox().getSelectedItem();
        }
        return (CloudConfiguration)this.myCloudDeviceConfigurationCombo.getComboBox().getSelectedItem();
    }

    private boolean isCloudProjectSpecified(CloudConfiguration.Kind configurationKind) {
        if (configurationKind == CloudConfiguration.Kind.MATRIX) {
            return this.myCloudMatrixProjectIdLabel.isProjectSpecified();
        }
        return this.myCloudDeviceProjectIdLabel.isProjectSpecified();
    }

    public int getSelectedCloudConfigurationId(CloudConfiguration.Kind configurationKind) {
        CloudConfiguration selection = this.getCloudConfigurationComboSelection(configurationKind);
        if (selection == null) {
            return -1;
        }
        return selection.getId();
    }

    private boolean isValidCloudSelection(CloudConfiguration.Kind configurationKind) {
        CloudConfiguration selection = this.getCloudConfigurationComboSelection(configurationKind);
        return selection != null && selection.getDeviceConfigurationCount() > 0 && this.isCloudProjectSpecified(configurationKind);
    }

    private String getInvalidSelectionErrorMessage(CloudConfiguration.Kind configurationKind) {
        CloudConfiguration selection = this.getCloudConfigurationComboSelection(configurationKind);
        if (selection == null) {
            return "Cloud configuration not specified";
        }
        if (selection.getDeviceConfigurationCount() < 1) {
            return "Selected cloud configuration is empty";
        }
        if (!this.isCloudProjectSpecified(configurationKind)) {
            return "Cloud project not specified";
        }
        return "";
    }

    @Nullable
    private String getAvdCompatibilityWarning() {
        IdDisplay selectedItem = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedItem != null) {
            String selectedAvdName = selectedItem.getId();
            Module module = this.getModuleSelector().getModule();
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                return null;
            }
            AvdInfo avd = avdManager.getAvd(selectedAvdName, false);
            if (avd == null || avd.getTarget() == null) {
                return null;
            }
            AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            AndroidVersion minSdk = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
            LaunchCompatibility compatibility = LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avd.getTarget());
            if (compatibility.isCompatible() == ThreeState.NO) {
                return String.format("'%1$s' may be incompatible with your configuration (%2$s)", selectedAvdName, StringUtil.notNullize((String)compatibility.getReason()));
            }
        }
        return null;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    @Nullable
    private static Object findAvdWithName(@NotNull JComboBox avdCombo, @NotNull String avdName) {
        if (avdCombo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdCombo", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "findAvdWithName"));
        }
        if (avdName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "findAvdWithName"));
        }
        int n = avdCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object item = avdCombo.getItemAt(i);
            if (!(item instanceof IdDisplay) || !avdName.equals(((IdDisplay)item).getId())) continue;
            return item;
        }
        return null;
    }

    protected void resetEditorFrom(T configuration) {
        TargetSelectionMode targetSelectionMode;
        this.myCloudMatrixProjectIdLabel.setConfiguration((AndroidRunConfigurationBase)((Object)configuration));
        this.myCloudMatrixConfigurationCombo.setConfiguration((AndroidRunConfigurationBase)((Object)configuration));
        this.myCloudDeviceProjectIdLabel.setConfiguration((AndroidRunConfigurationBase)((Object)configuration));
        this.myCloudDeviceConfigurationCombo.setConfiguration((AndroidRunConfigurationBase)((Object)configuration));
        this.myModuleSelector.reset(configuration);
        this.updateGoogleCloudVisible((AndroidRunConfigurationBase)((Object)configuration));
        JComboBox combo = this.myAvdCombo.getComboBox();
        String avd = ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD;
        if (avd != null) {
            Object item = AndroidRunConfigurationEditor.findAvdWithName(combo, avd);
            if (item != null) {
                combo.setSelectedItem(item);
            } else {
                combo.setSelectedItem(null);
                this.incorrectPreferredAvd = avd;
            }
        }
        this.myShowChooserRadioButton.setSelected((targetSelectionMode = ((AndroidRunConfigurationBase)((Object)configuration)).getTargetSelectionMode()) == TargetSelectionMode.SHOW_DIALOG);
        this.myEmulatorRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.EMULATOR);
        this.myUsbDeviceRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.USB_DEVICE);
        this.myUseLastSelectedDeviceCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).USE_LAST_SELECTED_DEVICE);
        this.myRunTestsInGoogleCloudRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.CLOUD_MATRIX_TEST);
        this.myCloudMatrixConfigurationCombo.selectConfiguration(((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
        this.myCloudMatrixProjectIdLabel.updateCloudProjectId(((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_MATRIX_PROJECT_ID);
        this.myLaunchCloudDeviceRadioButton.setSelected(targetSelectionMode == TargetSelectionMode.CLOUD_DEVICE_LAUNCH);
        this.myCloudDeviceConfigurationCombo.selectConfiguration(((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_DEVICE_CONFIGURATION_ID);
        this.myCloudDeviceProjectIdLabel.updateCloudProjectId(((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_DEVICE_PROJECT_ID);
        this.myAvdComboComponent.setEnabled(targetSelectionMode == TargetSelectionMode.EMULATOR);
        this.resetAvdCompatibilityWarningLabel(targetSelectionMode == TargetSelectionMode.EMULATOR ? this.getAvdCompatibilityWarning() : null);
        this.myUseAdditionalCommandLineOptionsCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).USE_COMMAND_LINE);
        this.myCommandLineField.setText(((AndroidRunConfigurationBase)((Object)configuration)).COMMAND_LINE);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
        this.myWipeUserDataCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).WIPE_USER_DATA);
        this.myDisableBootAnimationCombo.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).DISABLE_BOOT_ANIMATION);
        AndroidRunConfigurationEditor.selectItemCaseInsensitively(this.myNetworkSpeedCombo, ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_SPEED);
        AndroidRunConfigurationEditor.selectItemCaseInsensitively(this.myNetworkLatencyCombo, ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_LATENCY);
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY);
        this.myFilterLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)((Object)configuration)).FILTER_LOGCAT_AUTOMATICALLY);
        this.updateEnabled();
    }

    private static void selectItemCaseInsensitively(@NotNull JComboBox comboBox, @Nullable String item) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "selectItemCaseInsensitively"));
        }
        if (item == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = comboBox.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof String) || !item.equalsIgnoreCase((String)element)) continue;
            comboBox.setSelectedItem(element);
            return;
        }
    }

    protected void applyEditorTo(T configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo(configuration);
        if (this.myShowChooserRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.SHOW_DIALOG);
        } else if (this.myEmulatorRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.EMULATOR);
        } else if (this.myUsbDeviceRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.USB_DEVICE);
        } else if (this.myRunTestsInGoogleCloudRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.CLOUD_MATRIX_TEST);
        } else if (this.myLaunchCloudDeviceRadioButton.isSelected()) {
            ((AndroidRunConfigurationBase)((Object)configuration)).setTargetSelectionMode(TargetSelectionMode.CLOUD_DEVICE_LAUNCH);
        }
        ((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = this.getSelectedCloudConfigurationId(CloudConfiguration.Kind.MATRIX);
        ((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_MATRIX_PROJECT_ID = this.myCloudMatrixProjectIdLabel.getText();
        ((AndroidRunConfigurationBase)((Object)configuration)).IS_VALID_CLOUD_MATRIX_SELECTION = this.isValidCloudSelection(CloudConfiguration.Kind.MATRIX);
        ((AndroidRunConfigurationBase)((Object)configuration)).INVALID_CLOUD_MATRIX_SELECTION_ERROR = this.getInvalidSelectionErrorMessage(CloudConfiguration.Kind.MATRIX);
        ((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_DEVICE_CONFIGURATION_ID = this.getSelectedCloudConfigurationId(CloudConfiguration.Kind.SINGLE_DEVICE);
        ((AndroidRunConfigurationBase)((Object)configuration)).SELECTED_CLOUD_DEVICE_PROJECT_ID = this.myCloudDeviceProjectIdLabel.getText();
        ((AndroidRunConfigurationBase)((Object)configuration)).IS_VALID_CLOUD_DEVICE_SELECTION = this.isValidCloudSelection(CloudConfiguration.Kind.SINGLE_DEVICE);
        ((AndroidRunConfigurationBase)((Object)configuration)).INVALID_CLOUD_DEVICE_SELECTION_ERROR = this.getInvalidSelectionErrorMessage(CloudConfiguration.Kind.SINGLE_DEVICE);
        ((AndroidRunConfigurationBase)((Object)configuration)).USE_LAST_SELECTED_DEVICE = this.myUseLastSelectedDeviceCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).COMMAND_LINE = this.myCommandLineField.getText();
        ((AndroidRunConfigurationBase)((Object)configuration)).USE_COMMAND_LINE = this.myUseAdditionalCommandLineOptionsCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD = "";
        ((AndroidRunConfigurationBase)((Object)configuration)).WIPE_USER_DATA = this.myWipeUserDataCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).DISABLE_BOOT_ANIMATION = this.myDisableBootAnimationCombo.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_SPEED = ((String)this.myNetworkSpeedCombo.getSelectedItem()).toLowerCase();
        ((AndroidRunConfigurationBase)((Object)configuration)).NETWORK_LATENCY = ((String)this.myNetworkLatencyCombo.getSelectedItem()).toLowerCase();
        ((AndroidRunConfigurationBase)((Object)configuration)).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)((Object)configuration)).FILTER_LOGCAT_AUTOMATICALLY = this.myFilterLogcatCheckBox.isSelected();
        if (this.myAvdComboComponent.isEnabled()) {
            JComboBox combo = this.myAvdCombo.getComboBox();
            IdDisplay preferredAvd = (IdDisplay)combo.getSelectedItem();
            ((AndroidRunConfigurationBase)((Object)configuration)).PREFERRED_AVD = preferredAvd == null ? (this.incorrectPreferredAvd != null ? this.incorrectPreferredAvd : "") : preferredAvd.getId();
        }
        this.myConfigurationSpecificEditor.applyTo(configuration);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        RawCommandLineEditor rawCommandLineEditor;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JRadioButton jRadioButton;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox6;
        JBLabel jBLabel5;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel6;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Module:");
        jBLabel6.setDisplayedMnemonic('M');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.title"), 0, 0, null, null));
        this.myEmulatorRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.emulator"));
        jPanel4.add((Component)jRadioButton5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUsbDeviceRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.usb.device"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myShowChooserRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.show.dialog"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMinSdkInfoMessageLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.min.sdk.info.message"));
        jPanel4.add((Component)jBLabel5, new GridConstraints(5, 0, 1, 2, 8, 2, 0, 0, null, null, null, 2));
        this.myUseLastSelectedDeviceCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Use same device for future launches");
        jPanel4.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        this.myRunTestsInGoogleCloudRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Run tests in Google Cloud");
        jRadioButton2.setMnemonic('G');
        jRadioButton2.setDisplayedMnemonicIndex(13);
        jPanel4.add((Component)jRadioButton2, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, new Dimension(23, 17), null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.prefer.avd.label"));
        jPanel4.add((Component)jBLabel7, new GridConstraints(4, 0, 1, 1, 8, 2, 0, 0, null, null, null, 2));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myAvdComboComponent;
        jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(4, 1, 1, 1, 8, 2, 3, 3, new Dimension(200, -1), null, null));
        this.myCloudMatrixConfigLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Test Devices Configuration:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(10, 0, 1, 1, 8, 2, 0, 0, null, null, null, 2));
        CloudConfigurationComboBox cloudConfigurationComboBox = this.myCloudMatrixConfigurationCombo;
        jPanel4.add((Component)((Object)cloudConfigurationComboBox), new GridConstraints(10, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCloudMatrixProjectLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Cloud Project:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(11, 0, 1, 1, 8, 2, 0, 0, null, null, null, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel5, new GridConstraints(11, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        CloudProjectIdLabel cloudProjectIdLabel = this.myCloudMatrixProjectIdLabel;
        Component component = jPanel5.add((Component)((Object)cloudProjectIdLabel));
        ActionButton actionButton = this.myCloudMatrixProjectIdUpdateButton;
        Component component2 = jPanel5.add((Component)actionButton);
        this.myLaunchCloudDeviceRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Launch Cloud Device");
        jRadioButton.setMnemonic('D');
        jRadioButton.setDisplayedMnemonicIndex(13);
        jPanel4.add((Component)jRadioButton, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, new Dimension(23, 17), null));
        this.myCloudDeviceConfigLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Cloud Device Configuration:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(7, 0, 1, 1, 8, 2, 0, 0, null, null, null, 2));
        CloudConfigurationComboBox cloudConfigurationComboBox2 = this.myCloudDeviceConfigurationCombo;
        jPanel4.add((Component)((Object)cloudConfigurationComboBox2), new GridConstraints(7, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCloudDeviceProjectLabel = jBLabel = new JBLabel();
        jBLabel.setText("Cloud Project:");
        jPanel4.add((Component)jBLabel, new GridConstraints(8, 0, 1, 1, 8, 2, 0, 0, null, null, null, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel6, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        CloudProjectIdLabel cloudProjectIdLabel2 = this.myCloudDeviceProjectIdLabel;
        Component component3 = jPanel6.add((Component)((Object)cloudProjectIdLabel2));
        ActionButton actionButton2 = this.myCloudDeviceProjectIdUpdateButton;
        Component component4 = jPanel6.add((Component)actionButton2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.emulator.tab.title"), null, jPanel7, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.network.spped.label"));
        jPanel8.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkSpeedCombo = jComboBox2 = new JComboBox();
        jPanel8.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        Spacer spacer4 = new Spacer();
        jPanel8.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.network.latency.label"));
        jPanel8.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkLatencyCombo = jComboBox = new JComboBox();
        jPanel8.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        this.myWipeUserDataCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.wipe.user.data.label"));
        jPanel8.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myDisableBootAnimationCombo = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.disable.boot.animation.label"));
        jPanel8.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel8.add((Component)spacer5, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUseAdditionalCommandLineOptionsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Additional command line options:");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(11);
        jPanel9.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLineField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel9.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.tab.title"), null, jPanel10, null);
        this.myClearLogCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.skip.content.label"));
        jPanel10.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel10.add((Component)spacer6, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show logcat automatically");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFilterLogcatCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Filter to only show output from this application");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel6.setLabelFor((Component)modulesComboBox);
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class SelectCloudProjectAction
    extends AnAction {
        private final CloudProjectIdLabel myLabel;
        private final CloudConfigurationComboBox myComboBox;

        public SelectCloudProjectAction(CloudProjectIdLabel label, CloudConfigurationComboBox comboBox) {
            this.myLabel = label;
            this.myComboBox = comboBox;
        }

        public void actionPerformed(AnActionEvent e) {
            if (AndroidRunConfigurationEditor.this.myCloudConfigurationProvider == null) {
                return;
            }
            String selectedProjectId = AndroidRunConfigurationEditor.this.myCloudConfigurationProvider.openCloudProjectConfigurationDialog(AndroidRunConfigurationEditor.this.myProject, this.myLabel.getText());
            if (selectedProjectId != null) {
                this.myLabel.updateCloudProjectId(selectedProjectId);
                for (ItemListener itemListener : this.myComboBox.getComboBox().getItemListeners()) {
                    itemListener.itemStateChanged(new ItemEvent(this.myComboBox.getComboBox(), 701, this.myComboBox.getComboBox(), 1));
                }
            }
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(AllIcons.General.Settings);
        }
    }
}

