/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExtension;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public abstract class MavenArtifactCoordinatesConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(context.getProject());
        return this.selectStrategy(context).isValid(id, manager, context) ? s : null;
    }

    protected abstract boolean doIsValid(MavenId var1, MavenProjectIndicesManager var2, ConvertContext var3);

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(context.getProject());
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        MavenDomShortArtifactCoordinates coordinates = MavenArtifactCoordinatesHelper.getCoordinates(context);
        Set<String> set = this.selectStrategy(context).getVariants(id, manager, coordinates);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter", "getVariants"));
        }
        return set;
    }

    protected abstract Set<String> doGetVariants(MavenId var1, MavenProjectIndicesManager var2);

    public PsiElement resolve(String o, ConvertContext context) {
        MavenId id = MavenArtifactCoordinatesHelper.getId(context);
        PsiFile result = this.selectStrategy(context).resolve(id, context);
        return result != null ? result : super.resolve((Object)o, context);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return this.selectStrategy(context).getContextName() + " '''" + MavenArtifactCoordinatesHelper.getId(context) + "''' not found";
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context), (Object)new MyUpdateIndicesFix());
    }

    @Override
    public boolean isSoft(@NotNull DomElement element) {
        DomElement pluginsElement;
        DomElement dependencies;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter", "isSoft"));
        }
        DomElement dependencyOrPluginElement = element.getParent();
        return dependencyOrPluginElement instanceof MavenDomDependency ? (dependencies = dependencyOrPluginElement.getParent()) instanceof MavenDomDependencies && dependencies.getParent() instanceof MavenDomDependencyManagement : dependencyOrPluginElement instanceof MavenDomPlugin && (pluginsElement = dependencyOrPluginElement.getParent()) instanceof MavenDomPlugins && pluginsElement.getParent() instanceof MavenDomPluginManagement;
    }

    @Nullable
    protected MavenProject findMavenProject(ConvertContext context) {
        PsiFile psiFile = context.getFile().getOriginalFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(psiFile.getProject()).findProject(file);
    }

    private ConverterStrategy selectStrategy(ConvertContext context) {
        DomElement parent = context.getInvocationElement().getParent();
        if (parent instanceof MavenDomProjectModel) {
            return new ProjectStrategy();
        }
        if (parent instanceof MavenDomParent) {
            return new ParentStrategy((MavenDomParent)parent);
        }
        if (parent instanceof MavenDomDependency) {
            return new DependencyStrategy((MavenDomDependency)parent);
        }
        if (parent instanceof MavenDomExclusion) {
            return new ExclusionStrategy();
        }
        if (parent instanceof MavenDomPlugin) {
            return new PluginOrExtensionStrategy(true);
        }
        if (parent instanceof MavenDomExtension) {
            return new PluginOrExtensionStrategy(false);
        }
        return new ConverterStrategy();
    }

    private class PluginOrExtensionStrategy
    extends ConverterStrategy {
        private final boolean myPlugin;

        public PluginOrExtensionStrategy(boolean isPlugin) {
            this.myPlugin = isPlugin;
        }

        @Override
        public String getContextName() {
            return this.myPlugin ? "Plugin" : "Build Extension";
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    if (!super.isValid(id = new MavenId(each, id.getArtifactId(), id.getVersion()), manager, context)) continue;
                    return true;
                }
                return false;
            }
            return super.isValid(id, manager, context);
        }

        @Override
        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                THashSet result = new THashSet();
                for (String each : this.getGroupIdVariants(manager, coordinates)) {
                    id = new MavenId(each, id.getArtifactId(), id.getVersion());
                    result.addAll(super.getVariants(id, manager, coordinates));
                }
                return result;
            }
            return super.getVariants(id, manager, coordinates);
        }

        private String[] getGroupIdVariants(MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (DomUtil.hasXml(coordinates.getGroupId())) {
                Set<String> strings = manager.getGroupIds();
                return ArrayUtil.toStringArray(strings);
            }
            return MavenArtifactUtil.DEFAULT_GROUPS;
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            PsiFile res = super.resolve(id, context);
            if (res != null) {
                return res;
            }
            MavenProject mavenProject = MavenArtifactCoordinatesConverter.this.findMavenProject(context);
            if (mavenProject != null) {
                for (MavenPlugin plugin : mavenProject.getPlugins()) {
                    if (!MavenArtifactUtil.isPluginIdEquals(id.getGroupId(), id.getArtifactId(), plugin.getGroupId(), plugin.getArtifactId())) continue;
                    return super.resolve(plugin.getMavenId(), context);
                }
            }
            PsiManager psiManager = context.getPsiManager();
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(psiManager.getProject());
            File artifactFile = MavenArtifactUtil.getArtifactFile(projectsManager.getLocalRepository(), id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(artifactFile);
            if (virtualFile != null) {
                return psiManager.findFile(virtualFile);
            }
            return null;
        }
    }

    private class ExclusionStrategy
    extends ConverterStrategy {
        private ExclusionStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class DependencyStrategy
    extends ConverterStrategy {
        private final MavenDomDependency myDependency;

        public DependencyStrategy(MavenDomDependency dependency) {
            this.myDependency = dependency;
        }

        @Override
        public String getContextName() {
            return "Dependency";
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            MavenDomDependency managedDependency;
            MavenArtifact artifact;
            PsiFile res = super.resolve(id, context);
            if (res != null) {
                return res;
            }
            DomElement parent = context.getInvocationElement().getParent();
            if (!(parent instanceof MavenDomDependency)) {
                return null;
            }
            DependencyConflictId dependencyId = DependencyConflictId.create((MavenDomDependency)parent);
            if (dependencyId == null) {
                return null;
            }
            MavenProject mavenProject = MavenArtifactCoordinatesConverter.this.findMavenProject(context);
            if (mavenProject != null && (artifact = mavenProject.getDependencyArtifactIndex().findArtifacts(dependencyId)) != null && artifact.isResolved()) {
                return super.resolve(new MavenId(id.getGroupId(), id.getArtifactId(), artifact.getVersion()), context);
            }
            if (id.getVersion() == null && (managedDependency = MavenDomProjectProcessorUtils.searchManagingDependency((MavenDomDependency)parent)) != null) {
                final GenericDomValue managedDependencyArtifactId = managedDependency.getArtifactId();
                return (PsiFile)RecursionManager.doPreventingRecursion((Object)managedDependencyArtifactId, (boolean)false, (Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        PsiElement res = new GenericDomValueReference(managedDependencyArtifactId).resolve();
                        return res instanceof PsiFile ? (PsiFile)res : null;
                    }
                });
            }
            return null;
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myDependency.getSystemPath().getValue();
        }

        @Override
        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                THashSet result = new THashSet();
                for (String each : manager.getGroupIds()) {
                    id = new MavenId(each, id.getArtifactId(), id.getVersion());
                    result.addAll(super.getVariants(id, manager, coordinates));
                }
                return result;
            }
            return super.getVariants(id, manager, coordinates);
        }
    }

    private class ParentStrategy
    extends ConverterStrategy {
        private final MavenDomParent myParent;

        public ParentStrategy(MavenDomParent parent) {
            this.myParent = parent;
        }

        @Override
        public String getContextName() {
            return "Project";
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myParent.getRelativePath().getValue();
        }
    }

    private class ProjectStrategy
    extends ConverterStrategy {
        private ProjectStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return true;
        }
    }

    private class ConverterStrategy {
        private ConverterStrategy() {
        }

        public String getContextName() {
            return "Artifact";
        }

        public boolean isValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
            return MavenArtifactCoordinatesConverter.this.doIsValid(id, manager, context) || this.resolveBySpecifiedPath() != null;
        }

        public Set<String> getVariants(MavenId id, MavenProjectIndicesManager manager, MavenDomShortArtifactCoordinates coordinates) {
            return MavenArtifactCoordinatesConverter.this.doGetVariants(id, manager);
        }

        public PsiFile resolve(MavenId id, ConvertContext context) {
            PsiManager psiManager = context.getPsiManager();
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(psiManager.getProject());
            PsiFile result = this.resolveBySpecifiedPath();
            if (result != null) {
                return result;
            }
            result = this.resolveInProjects(id, projectsManager, psiManager);
            if (result != null) {
                return result;
            }
            return this.resolveInLocalRepository(id, projectsManager, psiManager);
        }

        @Nullable
        protected PsiFile resolveBySpecifiedPath() {
            return null;
        }

        private PsiFile resolveInProjects(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            MavenProject project = projectsManager.findProject(id);
            return project == null ? null : psiManager.findFile(project.getFile());
        }

        private PsiFile resolveInLocalRepository(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            File file = this.makeLocalRepositoryFile(id, projectsManager.getLocalRepository());
            if (file == null) {
                return null;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (virtualFile == null) {
                return null;
            }
            return psiManager.findFile(virtualFile);
        }

        private File makeLocalRepositoryFile(MavenId id, File localRepository) {
            String relPath = StringUtil.notNullize((String)id.getGroupId(), (String)"null").replace(".", "/");
            relPath = relPath + "/" + id.getArtifactId();
            relPath = relPath + "/" + id.getVersion();
            relPath = relPath + "/" + id.getArtifactId() + "-" + id.getVersion() + ".pom";
            return new File(localRepository, relPath);
        }
    }

    private static class MyUpdateIndicesFix
    implements LocalQuickFix {
        private MyUpdateIndicesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.update.indices", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesFix", "applyFix"));
            }
            MavenProjectIndicesManager.getInstance(project).scheduleUpdateAll();
        }
    }
}

