/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateDependencyUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class GenerateManagedDependencyAction
extends GenerateDomElementAction {
    public GenerateManagedDependencyAction() {
        super((GenerateDomElementProvider)new MavenOverridingDependencyGenerateProvider(), AllIcons.Nodes.PpLib);
    }

    protected boolean startInWriteAction() {
        return false;
    }

    private static Set<DependencyConflictId> collectExistingDependencies(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction", "collectExistingDependencies"));
        }
        HashSet existingDependencies = new HashSet();
        for (MavenDomDependency dependency : model.getDependencies().getDependencies()) {
            DependencyConflictId id = DependencyConflictId.create(dependency);
            if (id == null) continue;
            existingDependencies.add(id);
        }
        return existingDependencies;
    }

    @NotNull
    public static Map<DependencyConflictId, MavenDomDependency> collectManagingDependencies(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction", "collectManagingDependencies"));
        }
        HashMap dependencies = new HashMap();
        Processor<MavenDomDependency> collectProcessor = new Processor<MavenDomDependency>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map;
            }

            public boolean process(MavenDomDependency dependency) {
                DependencyConflictId id = DependencyConflictId.create(dependency);
                if (id != null && !this.val$dependencies.containsKey(id)) {
                    this.val$dependencies.put(id, dependency);
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, collectProcessor, model.getManager().getProject());
        HashMap hashMap = dependencies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction", "collectManagingDependencies"));
        }
        return hashMap;
    }

    private static class MavenOverridingDependencyGenerateProvider
    extends MavenGenerateProvider<MavenDomDependency> {
        public MavenOverridingDependencyGenerateProvider() {
            super(MavenDomBundle.message("generate.managed.dependency", new Object[0]), MavenDomDependency.class);
        }

        @Override
        protected MavenDomDependency doGenerate(final @NotNull MavenDomProjectModel mavenModel, final Editor editor) {
            if (mavenModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModel", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction$MavenOverridingDependencyGenerateProvider", "doGenerate"));
            }
            Set existingDependencies = GenerateManagedDependencyAction.collectExistingDependencies(mavenModel);
            Map<DependencyConflictId, MavenDomDependency> managingDependencies = GenerateManagedDependencyAction.collectManagingDependencies(mavenModel);
            Map unexistManagingDeps = Maps.filterKeys(managingDependencies, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)existingDependencies)));
            final List<MavenDomDependency> dependenciesToOverride = GenerateDependencyUtil.chooseDependencies(unexistManagingDeps.values(), mavenModel.getManager().getProject());
            if (!dependenciesToOverride.isEmpty()) {
                return (MavenDomDependency)new WriteCommandAction<MavenDomDependency>(editor.getProject(), new PsiFile[]{mavenModel.getXmlTag().getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/generate/GenerateManagedDependencyAction$MavenOverridingDependencyGenerateProvider$1", "run"));
                        }
                        for (MavenDomDependency parentDependency : dependenciesToOverride) {
                            String groupId = parentDependency.getGroupId().getStringValue();
                            String artifactId = parentDependency.getArtifactId().getStringValue();
                            if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
                            MavenDomDependency dependency = MavenDomUtil.createDomDependency(mavenModel, editor);
                            dependency.getGroupId().setStringValue(groupId);
                            dependency.getArtifactId().setStringValue(artifactId);
                            String typeValue = parentDependency.getType().getStringValue();
                            String classifier = parentDependency.getClassifier().getStringValue();
                            if (!StringUtil.isEmptyOrSpaces((String)typeValue)) {
                                dependency.getType().setStringValue(typeValue);
                            }
                            if (!StringUtil.isEmptyOrSpaces((String)classifier)) {
                                dependency.getClassifier().setStringValue(classifier);
                            }
                            dependency.getVersion().undefine();
                        }
                    }
                }.execute().getResultObject();
            }
            return null;
        }
    }
}

