/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkValueTypeStrategy
implements ModelSchemaExtractionStrategy {
    private static final List<ModelType<?>> TYPES = ImmutableList.of(ModelType.of(String.class), ModelType.of(Boolean.class), ModelType.of(Character.class), ModelType.of(Integer.class), ModelType.of(Long.class), ModelType.of(Double.class), ModelType.of(BigInteger.class), ModelType.of(BigDecimal.class), ModelType.of(File.class));
    private static final List<ModelType<?>> NON_FINAL_TYPES = ImmutableList.of(ModelType.of(BigInteger.class), ModelType.of(BigDecimal.class));

    public <R> ModelSchemaExtractionResult<R> extract(ModelSchemaExtractionContext<R> extractionContext, ModelSchemaCache cache) {
        ModelType<R> type = extractionContext.getType();
        if (TYPES.contains(type)) {
            return new ModelSchemaExtractionResult<R>(ModelSchema.value(type));
        }
        for (ModelType<R> modelType : NON_FINAL_TYPES) {
            if (!modelType.isAssignableFrom(type)) continue;
            throw new InvalidManagedModelElementTypeException(extractionContext, "subclasses of " + modelType + " are not supported");
        }
        return null;
    }

    @Override
    public Iterable<String> getSupportedManagedTypes() {
        return Collections.singleton("JDK value types: " + Joiner.on((String)", ").join(Iterables.transform(TYPES, (Function)new Function<ModelType<?>, Object>(){

            public Object apply(ModelType<?> input) {
                return input.getRawClass().getSimpleName();
            }
        })));
    }
}

