/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.RuleBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MutatorRuleBinder<T>
extends RuleBinder {
    private ModelBinding subjectBinding;
    private final ModelAction<T> action;

    public MutatorRuleBinder(BindingPredicate subjectReference, List<BindingPredicate> inputs, ModelAction<T> action, Collection<RuleBinder> binders) {
        super(subjectReference, inputs, action.getDescriptor(), binders);
        this.subjectBinding = this.binding(subjectReference, true, new Action<ModelBinding>(){

            public void execute(ModelBinding modelBinding) {
                ModelNodeInternal node = modelBinding.getNode();
                BindingPredicate predicate = modelBinding.getPredicate();
                if (predicate.getState() != null && node.getState().compareTo(predicate.getState()) >= 0) {
                    throw new IllegalStateException(String.format("Cannot add rule %s for model element '%s' at state %s as this element is already at state %s.", new Object[]{modelBinding.referrer, node.getPath(), predicate.getState().previous(), node.getState()}));
                }
                MutatorRuleBinder.this.maybeFire();
            }
        });
        this.action = action;
    }

    public ModelAction<T> getAction() {
        return this.action;
    }

    @Override
    public ModelBinding getSubjectBinding() {
        return this.subjectBinding;
    }

    @Override
    public boolean isBound() {
        return this.subjectBinding != null && this.subjectBinding.isBound() && super.isBound();
    }
}

