/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.annotations.NonNull;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.IMergerLog;
import com.android.manifmerger.ManifestMerger;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllegalFormatException;
import java.util.List;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidManifestMergingTarget;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidManifestMergingBuilder
extends AndroidTargetBuilder<AndroidManifestMergingTarget.MyRootDescriptor, AndroidManifestMergingTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidManifestMergingBuilder");
    private static final String BUILDER_NAME = "Android Manifest Merger";

    public AndroidManifestMergingBuilder() {
        super(Collections.singletonList(AndroidManifestMergingTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidManifestMergingTarget target, @NotNull DirtyFilesHolder<AndroidManifestMergingTarget.MyRootDescriptor, AndroidManifestMergingTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidManifestMergingBuilder", "buildTarget"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/android/AndroidManifestMergingBuilder", "buildTarget"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/android/AndroidManifestMergingBuilder", "buildTarget"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidManifestMergingBuilder", "buildTarget"));
        }
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        try {
            if (!AndroidManifestMergingBuilder.doManifestMerging(target, context, outputConsumer)) {
                throw new StopBuildException();
            }
        }
        catch (ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            AndroidJpsUtil.handleException(context, e, BUILDER_NAME, LOG);
        }
    }

    private static boolean doManifestMerging(AndroidManifestMergingTarget target, CompileContext context, BuildOutputConsumer outputConsumer) throws IOException {
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        assert (extension != null);
        assert (!extension.isLibrary());
        assert (extension.isManifestMergingEnabled());
        File outputDir = target.getOutputDirectory(context);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", outputDir.getPath())));
            return false;
        }
        File manifestFile = null;
        ArrayList<File> libManifests = new ArrayList<File>();
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        for (AndroidManifestMergingTarget.MyRootDescriptor root : roots) {
            if (root.isLibManifestRoot()) {
                libManifests.add(root.getRootFile());
                continue;
            }
            manifestFile = root.getRootFile();
        }
        if (manifestFile == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.manifest.not.found", module.getName())));
            return false;
        }
        File outputFile = new File(outputDir, "AndroidManifest.xml");
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        if (!AndroidManifestMergingBuilder.doMergeManifests(context, platform.getLocalSdk(), manifestFile, libManifests, outputFile)) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "[" + module.getName() + "] Cannot perform manifest merging"));
            return false;
        }
        ArrayList<String> srcPaths = new ArrayList<String>();
        srcPaths.add(manifestFile.getPath());
        for (File libManifest : libManifests) {
            srcPaths.add(libManifest.getPath());
        }
        outputConsumer.registerOutputFile(outputFile, srcPaths);
        return true;
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }

    private static boolean doMergeManifests(final CompileContext context, final LocalSdk localSdk, File manifestFile, List<File> libManifests, File outputFile) throws IOException {
        AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
        if (testingManager != null) {
            StringBuilder messageBuilder = new StringBuilder("manifest_merging\n");
            messageBuilder.append(manifestFile.getPath()).append('\n');
            Collections.sort(libManifests);
            for (File libManifest : libManifests) {
                messageBuilder.append(libManifest.getPath()).append('\n');
            }
            messageBuilder.append(outputFile.getPath());
            testingManager.getCommandExecutor().log(messageBuilder.toString());
        }
        ManifestMerger manifestMerger = new ManifestMerger(new IMergerLog(){

            public void error(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location, @NonNull String message, Object ... msgParams) {
                context.processMessage((BuildMessage)new CompilerMessage(AndroidManifestMergingBuilder.BUILDER_NAME, AndroidManifestMergingBuilder.toBuildMessageKind(severity), this.formatMessage(message, msgParams), location.getFileName(), -1L, -1L, -1L, (long)location.getLine(), -1L));
            }

            public void conflict(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location1, @NonNull IMergerLog.FileAndLine location2, @NonNull String message, Object ... msgParams) {
                StringBuilder builder = new StringBuilder("Conflicts:\n");
                String filePath1 = location1.getFileName();
                if (filePath1 != null) {
                    builder.append(FileUtil.toSystemDependentName((String)filePath1)).append(": line ").append(location1.getLine());
                } else {
                    builder.append("unknown");
                }
                builder.append('\n');
                String filePath2 = location2.getFileName();
                if (filePath2 != null) {
                    builder.append(FileUtil.toSystemDependentName((String)filePath2)).append(": line ").append(location1.getLine());
                } else {
                    builder.append("unknown");
                }
                builder.append('\n').append(this.formatMessage(message, msgParams));
                context.processMessage((BuildMessage)new CompilerMessage(AndroidManifestMergingBuilder.BUILDER_NAME, AndroidManifestMergingBuilder.toBuildMessageKind(severity), builder.toString(), filePath1, -1L, -1L, -1L, (long)location1.getLine(), -1L));
            }

            private String formatMessage(String message, Object ... msgParams) {
                try {
                    return String.format(message, msgParams);
                }
                catch (IllegalFormatException e) {
                    LOG.debug((Throwable)e);
                    return message;
                }
            }
        }, new ICallback(){

            public int queryCodenameApiLevel(@NonNull String codename) {
                try {
                    AndroidVersion version = new AndroidVersion(codename);
                    String hashString = AndroidTargetHash.getPlatformHashString((AndroidVersion)version);
                    IAndroidTarget t = localSdk.getTargetFromHashString(hashString);
                    if (t != null) {
                        return t.getVersion().getApiLevel();
                    }
                }
                catch (AndroidVersion.AndroidVersionException androidVersionException) {
                    // empty catch block
                }
                return 0;
            }
        });
        return manifestMerger.process(outputFile, manifestFile, libManifests.toArray(new File[libManifests.size()]), null, null);
    }

    private static BuildMessage.Kind toBuildMessageKind(IMergerLog.Severity severity) {
        if (severity == null) {
            return BuildMessage.Kind.INFO;
        }
        switch (severity) {
            case INFO: {
                return BuildMessage.Kind.INFO;
            }
            case WARNING: {
                return BuildMessage.Kind.WARNING;
            }
            case ERROR: {
                return BuildMessage.Kind.ERROR;
            }
        }
        return BuildMessage.Kind.INFO;
    }
}

