/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FxmlDataIndexer
implements DataIndexer<String, Set<String>, FileContent> {
    @NotNull
    public Map<String, Set<String>> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/javaFX/FxmlDataIndexer", "map"));
        }
        Map<String, Set<String>> map = this.getIds(inputData.getContentAsText().toString(), inputData.getFile(), inputData.getProject());
        if (map != null) {
            Map<String, Set<String>> map2 = map;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/FxmlDataIndexer", "map"));
            }
            return map2;
        }
        Map<String, Set<String>> map3 = Collections.emptyMap();
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/FxmlDataIndexer", "map"));
        }
        return map3;
    }

    @Nullable
    protected Map<String, Set<String>> getIds(String content, VirtualFile file, Project project) {
        if (!content.contains("http://javafx.com/fxml")) {
            return null;
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String path = file.getPath();
        IXMLBuilder handler = this.createParseHandler(path, map);
        try {
            NanoXmlUtil.parse((Reader)new StringReader(content), (IXMLBuilder)handler);
        }
        catch (StopException stopException) {
            // empty catch block
        }
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file);
        this.endDocument(path, sourceRoot, map, handler);
        return map;
    }

    protected void endDocument(String math, VirtualFile sourceRoot, Map<String, Set<String>> map, IXMLBuilder handler) {
    }

    protected IXMLBuilder createParseHandler(final String path, final Map<String, Set<String>> map) {
        return new NanoXmlUtil.IXMLBuilderAdapter(){

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (value != null && "fx:id".equals(nsPrefix + ":" + key)) {
                    HashSet<String> paths = (HashSet<String>)map.get(value);
                    if (paths == null) {
                        paths = new HashSet<String>();
                        map.put(value, paths);
                    }
                    paths.add(path);
                }
            }
        };
    }

    protected static class StopException
    extends RuntimeException {
        protected StopException() {
        }
    }
}

