/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.sceneBuilder.ErrorSceneBuilderCreator;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderCreator;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderCreatorImpl;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderEditor;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderInfo;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderProvider;
import org.jetbrains.plugins.javaFX.sceneBuilder.State;

public class SceneBuilderEditorProvider
implements FileEditorProvider,
DumbAware,
SceneBuilderProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderEditorProvider");
    private SceneBuilderCreatorImpl mySceneBuilderCreator;

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "accept"));
        }
        return "fxml".equalsIgnoreCase(file.getExtension()) && SystemInfo.isJavaVersionAtLeast((String)"1.8") && Registry.is((String)"embed.scene.builder");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        SceneBuilderEditor sceneBuilderEditor = new SceneBuilderEditor(project, file, this);
        if (sceneBuilderEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        return sceneBuilderEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if ("JavaFX-Scene-Builder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "getEditorTypeId"));
        }
        return "JavaFX-Scene-Builder";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    @Override
    public SceneBuilderCreator get(Project project, boolean choosePathIfEmpty) {
        if (this.mySceneBuilderCreator == null) {
            SceneBuilderInfo info = SceneBuilderInfo.get(project, choosePathIfEmpty);
            if (info == SceneBuilderInfo.EMPTY) {
                return new ErrorSceneBuilderCreator(State.EMPTY_PATH);
            }
            if (info.libPath == null) {
                return new ErrorSceneBuilderCreator(State.ERROR_PATH);
            }
            try {
                this.mySceneBuilderCreator = new SceneBuilderCreatorImpl(info);
            }
            catch (Throwable e) {
                LOG.error(e);
                return new ErrorSceneBuilderCreator(State.CREATE_ERROR);
            }
        }
        return this.mySceneBuilderCreator;
    }
}

