/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Visitor;
import java.util.ArrayList;
import java.util.List;

public class ClassInstance
extends Instance {
    private final long mValuesOffset;

    public ClassInstance(long id, @NonNull StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.mValuesOffset = valuesOffset;
    }

    @NonNull
    List<FieldValue> getFields(String name) {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (FieldValue value : this.getValues()) {
            if (!value.getField().getName().equals(name)) continue;
            result.add(value);
        }
        return result;
    }

    @NonNull
    public List<FieldValue> getValues() {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        this.getBuffer().setPosition(this.mValuesOffset);
        for (ClassObj clazz = this.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
            for (Field field : clazz.getFields()) {
                result.add(new FieldValue(field, this.readValue(field.getType())));
            }
        }
        return result;
    }

    @Override
    public final void accept(@NonNull Visitor visitor) {
        visitor.visitClassInstance(this);
        for (FieldValue field : this.getValues()) {
            if (!(field.getValue() instanceof Instance)) continue;
            if (!this.mReferencesAdded) {
                ((Instance)field.getValue()).addReference(this);
            }
            visitor.visitLater(this, (Instance)field.getValue());
        }
        this.mReferencesAdded = true;
    }

    @Override
    public boolean getIsSoftReference() {
        return this.getClassObj().getIsSoftReference();
    }

    public final String toString() {
        return String.format("%s@%d (0x%x)", this.getClassObj().getClassName(), this.getUniqueId(), this.getUniqueId());
    }

    public static class FieldValue {
        private Field mField;
        private Object mValue;

        public FieldValue(@NonNull Field field, @Nullable Object value) {
            this.mField = field;
            this.mValue = value;
        }

        public Field getField() {
            return this.mField;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

