/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class Dominators {
    @NonNull
    private final Snapshot mSnapshot;
    @NonNull
    private final ImmutableList<Instance> mTopSort;

    public Dominators(@NonNull Snapshot snapshot, @NonNull ImmutableList<Instance> topSort) {
        this.mSnapshot = snapshot;
        this.mTopSort = topSort;
        for (RootObj root : snapshot.getGCRoots()) {
            Instance ref = root.getReferredInstance();
            if (ref == null) continue;
            ref.setImmediateDominator(Snapshot.SENTINEL_ROOT);
        }
    }

    private void computeDominators() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.mTopSort.size(); ++i) {
                Instance node = (Instance)this.mTopSort.get(i);
                if (node.getImmediateDominator() == Snapshot.SENTINEL_ROOT) continue;
                Instance dominator = null;
                for (int j = 0; j < node.getHardReferences().size(); ++j) {
                    Instance predecessor = node.getHardReferences().get(j);
                    if (predecessor.getImmediateDominator() == null) continue;
                    if (dominator == null) {
                        dominator = predecessor;
                        continue;
                    }
                    Instance fingerA = dominator;
                    Instance fingerB = predecessor;
                    while (fingerA != fingerB) {
                        if (fingerA.getTopologicalOrder() < fingerB.getTopologicalOrder()) {
                            fingerB = fingerB.getImmediateDominator();
                            continue;
                        }
                        fingerA = fingerA.getImmediateDominator();
                    }
                    dominator = fingerA;
                }
                if (node.getImmediateDominator() == dominator) continue;
                node.setImmediateDominator(dominator);
                changed = true;
            }
        }
    }

    public void computeRetainedSizes() {
        for (Heap heap : this.mSnapshot.getHeaps()) {
            for (Instance instance : Iterables.concat(heap.getClasses(), heap.getInstances())) {
                instance.resetRetainedSize();
            }
        }
        this.computeDominators();
        for (Instance node : this.mSnapshot.getReachableInstances()) {
            int heapIndex = this.mSnapshot.getHeapIndex(node.getHeap());
            for (Instance dom = node.getImmediateDominator(); dom != Snapshot.SENTINEL_ROOT; dom = dom.getImmediateDominator()) {
                dom.addRetainedSize(heapIndex, node.getSize());
            }
        }
    }
}

