/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64Converter;
import gnu.trove.TIntArrayList;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]");

    private URLUtil() {
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openStream"));
        }
        String protocol = url.getProtocol();
        InputStream inputStream = protocol.equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openStream"));
        }
        return inputStream;
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        InputStream inputStream;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openResourceStream"));
        }
        try {
            inputStream = URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file != null && file.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file)) != null) {
                InputStream inputStream2 = resourceStream;
                if (inputStream2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openResourceStream"));
                }
                return inputStream2;
            }
            throw ex;
        }
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openResourceStream"));
        }
        return inputStream;
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile(FileUtil.unquote((String)paths.first));
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
        if (filterInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        return filterInputStream;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "splitJarUrl"));
        }
        int pivot = url.indexOf(JAR_SEPARATOR);
        if (pivot < 0) {
            return null;
        }
        String resourcePath = url.substring(pivot + 2);
        String jarPath = url.substring(0, pivot);
        if (StringUtil.startsWithConcatenation(jarPath, JAR_PROTOCOL, ":")) {
            jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
        }
        if (jarPath.startsWith(FILE_PROTOCOL)) {
            if ((jarPath = jarPath.substring(FILE_PROTOCOL.length())).startsWith(SCHEME_SEPARATOR)) {
                jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
            } else if (StringUtil.startsWithChar(jarPath, ':')) {
                jarPath = jarPath.substring(1);
            }
        }
        return Pair.create(jarPath, resourcePath);
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        if (s.indexOf(37) == -1) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
            }
            return string;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                TIntArrayList bytes = new TIntArrayList();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, CharsetToolkit.UTF8_CHARSET));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        String string = decoded.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        return string;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "containsScheme"));
        }
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/io/URLUtil", "isDataUri"));
        }
        return !value.isEmpty() && value.startsWith("data:", value.charAt(0) == '\"' || value.charAt(0) == '\'' ? 1 : 0);
    }

    @Nullable
    public static byte[] getBytesFromDataUri(@NotNull String dataUrl) {
        if (dataUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataUrl", "com/intellij/util/io/URLUtil", "getBytesFromDataUri"));
        }
        Matcher matcher = DATA_URI_PATTERN.matcher(StringUtil.unquoteString(dataUrl));
        if (matcher.matches()) {
            try {
                String content = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64Converter.decode(content.getBytes(CharsetToolkit.UTF8_CHARSET)) : content.getBytes(CharsetToolkit.UTF8_CHARSET);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        if (sshUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sshUrl", "com/intellij/util/io/URLUtil", "parseHostFromSshUrl"));
        }
        String host = sshUrl;
        int at = host.lastIndexOf(64);
        if (at > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(58);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        String string = host;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "parseHostFromSshUrl"));
        }
        return string;
    }
}

