/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.zip.DosTime;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.io.zip.ZipLong;
import com.intellij.util.io.zip.ZipShort;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;

class JBZipOutputStream {
    public static final int DEFAULT_COMPRESSION = -1;
    private String comment = "";
    private int level = -1;
    private int method = 0;
    private final CRC32 crc = new CRC32();
    long written = 0L;
    private String encoding = null;
    private final Deflater def = new Deflater(this.level, true);
    private final RandomAccessFile raf;
    private final JBZipFile myFile;
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private final BufferExposingByteArrayOutputStream myBuffer = new BufferExposingByteArrayOutputStream();

    public JBZipOutputStream(JBZipFile file, long currentCDOffset) throws IOException {
        this.myFile = file;
        this.raf = this.myFile.archive;
        this.written = currentCDOffset;
        this.raf.seek(currentCDOffset);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        long cdOffset = this.written;
        List<JBZipEntry> entries = this.myFile.getEntries();
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            this.writeCentralFileHeader(entries.get(i));
        }
        long cdLength = this.written - cdOffset;
        this.writeCentralDirectoryEnd(cdLength, cdOffset);
        this.flushBuffer();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + level);
        }
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    protected void writeLocalFileHeader(JBZipEntry ze) throws IOException {
        ze.setHeaderOffset(this.written);
        this.writeOut(LFH_SIG);
        this.writeOutShort(10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        this.writeOutLong(ze.getCompressedSize());
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getLocalFileDataExtra();
        this.writeOutShort(extra.length);
        this.writeOut(name);
        this.writeOut(extra);
    }

    private void writeOutShort(int s) throws IOException {
        this.writeOut(ZipShort.getBytes(s));
    }

    private void writeOutLong(long s) throws IOException {
        this.writeOut(ZipLong.getBytes(s));
    }

    protected void writeCentralFileHeader(JBZipEntry ze) throws IOException {
        this.writeOut(CFH_SIG);
        this.writeOutShort(ze.getPlatform() << 8 | 0x14);
        this.writeOutShort(10);
        this.writeOutShort(0);
        this.writeOutShort(ze.getMethod());
        this.writeOutLong(DosTime.javaToDosTime(ze.getTime()));
        this.writeOutLong(ze.getCrc());
        this.writeOutLong(ze.getCompressedSize());
        this.writeOutLong(ze.getSize());
        byte[] name = this.getBytes(ze.getName());
        this.writeOutShort(name.length);
        byte[] extra = ze.getExtra();
        this.writeOutShort(extra.length);
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] commentB = this.getBytes(comm);
        this.writeOutShort(commentB.length);
        this.writeOutShort(0);
        this.writeOutShort(ze.getInternalAttributes());
        this.writeOutLong(ze.getExternalAttributes());
        this.writeOutLong(ze.getHeaderOffset());
        this.writeOut(name);
        this.writeOut(extra);
        this.writeOut(commentB);
    }

    protected void writeCentralDirectoryEnd(long cdLength, long cdOffset) throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOutShort(0);
        this.writeOutShort(0);
        int entiresCount = this.myFile.getEntries().size();
        this.writeOutShort(entiresCount);
        this.writeOutShort(entiresCount);
        this.writeOutLong(cdLength);
        this.writeOutLong(cdOffset);
        byte[] data = this.getBytes(this.comment);
        this.writeOutShort(data.length);
        this.writeOut(data);
    }

    protected byte[] getBytes(String name) throws ZipException {
        if (this.encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    private void writeOut(byte[] data) throws IOException {
        this.writeOut(data, 0, data.length);
    }

    private void writeOut(byte[] data, int offset, int length) throws IOException {
        this.myBuffer.write(data, offset, length);
        if (this.myBuffer.size() > 8192) {
            this.flushBuffer();
        }
        this.written += (long)length;
    }

    private void flushBuffer() throws IOException {
        this.raf.write(this.myBuffer.getInternalBuffer(), 0, this.myBuffer.size());
        this.myBuffer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNextEntryBytes(JBZipEntry entry, byte[] bytes) throws IOException {
        byte[] outputBytes;
        int outputBytesLength;
        entry.setSize(bytes.length);
        this.crc.reset();
        this.crc.update(bytes);
        entry.setCrc(this.crc.getValue());
        if (entry.getMethod() == -1) {
            entry.setMethod(this.method);
        }
        if (entry.getTime() == -1L) {
            entry.setTime(System.currentTimeMillis());
        }
        if (entry.getMethod() == 8) {
            this.def.setLevel(this.level);
            BufferExposingByteArrayOutputStream compressedBytesStream = new BufferExposingByteArrayOutputStream();
            DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)compressedBytesStream, this.def);
            try {
                stream.write(bytes);
            }
            finally {
                stream.close();
            }
            outputBytesLength = compressedBytesStream.size();
            outputBytes = compressedBytesStream.getInternalBuffer();
        } else {
            outputBytesLength = bytes.length;
            outputBytes = bytes;
        }
        entry.setCompressedSize(outputBytesLength);
        this.writeLocalFileHeader(entry);
        this.writeOut(outputBytes, 0, outputBytesLength);
    }
}

