/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwoColorsIcon
extends EmptyIcon {
    @NotNull
    private final Paint myColor1;
    @NotNull
    private final Paint myColor2;
    private static final int SQUARE_SIZE = 6;
    private static final BufferedImage CHESS_IMAGE = UIUtil.createImage(6, 6, 1);
    private TexturePaint CHESS = new TexturePaint(CHESS_IMAGE, new Rectangle(0, 0, 6, 6));

    public TwoColorsIcon(int size, @Nullable Color color1, @Nullable Color color2) {
        super(size, size);
        this.myColor1 = color1 != null ? color1 : this.CHESS;
        this.myColor2 = color2 != null ? color2 : this.CHESS;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            GraphicsUtil.setupAAPainting(g2d);
            g2d.setPaint(this.myColor1);
            g2d.fillPolygon(new int[]{x, x + w, x}, new int[]{y, y, y + h}, 3);
            g2d.setPaint(this.myColor2);
            g2d.fillPolygon(new int[]{x + w, x + w, x}, new int[]{y, y + h, y + h}, 3);
        }
        catch (Exception e) {
            g2d.dispose();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwoColorsIcon icon = (TwoColorsIcon)o;
        if (this.getIconWidth() != icon.getIconWidth()) {
            return false;
        }
        if (this.getIconHeight() != icon.getIconHeight()) {
            return false;
        }
        if (!this.myColor1.equals(icon.myColor1)) {
            return false;
        }
        return this.myColor2.equals(icon.myColor2);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myColor1.hashCode();
        result = 31 * result + this.myColor2.hashCode();
        return result;
    }

    static {
        Graphics2D graphics = CHESS_IMAGE.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, 7, 7);
        graphics.setColor(Color.GRAY);
        graphics.fillRect(0, 0, 3, 3);
        graphics.fillRect(3, 3, 3, 3);
    }
}

