/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuiEditorAction
extends AnAction
implements DumbAware {
    private final boolean myModifying;

    protected AbstractGuiEditorAction() {
        this.myModifying = false;
    }

    protected AbstractGuiEditorAction(boolean modifying) {
        this.myModifying = modifying;
    }

    public final void actionPerformed(final AnActionEvent e) {
        final GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        if (editor != null) {
            final ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
            if (this.myModifying && !editor.ensureEditable()) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractGuiEditorAction.this.actionPerformed(editor, selection, e);
                    if (AbstractGuiEditorAction.this.myModifying) {
                        editor.refreshAndSave(true);
                    }
                }
            };
            if (this.getCommandName() != null) {
                CommandProcessor.getInstance().executeCommand(editor.getProject(), runnable, this.getCommandName(), null);
            } else {
                runnable.run();
            }
        }
    }

    protected abstract void actionPerformed(GuiEditor var1, List<RadComponent> var2, AnActionEvent var3);

    public final void update(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        if (editor == null) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
            ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
            this.update(editor, selection, e);
        }
    }

    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/AbstractGuiEditorAction", "update"));
        }
    }

    @Nullable
    protected String getCommandName() {
        return null;
    }
}

