/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureDialog;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodDescriptor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;
import org.jetbrains.plugins.groovy.refactoring.ui.MethodOrClosureScopeChooser;

public class CreateParameterFromUsageFix
extends Intention
implements MethodOrClosureScopeChooser.JBPopupOwner {
    private final String myName;
    private JBPopup myEnclosingMethodsPopup = null;

    public CreateParameterFromUsageFix(GrReferenceExpression ref) {
        this.myName = ref.getReferenceName();
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.parameter.from.usage", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public JBPopup get() {
        return this.myEnclosingMethodsPopup;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "processIntention"));
        }
        if (element instanceof GrReferenceExpression) {
            this.findScope((GrReferenceExpression)element, editor, project);
        }
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return element instanceof GrExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrReferenceExpression;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private void findScope(final @NotNull GrReferenceExpression ref, @NotNull Editor editor, final Project project) {
        GrMethod parent;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "findScope"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/annotator/intentions/CreateParameterFromUsageFix", "findScope"));
        }
        GrTopStatement place = ref;
        ArrayList<GrMethod> scopes = new ArrayList<GrMethod>();
        while ((parent = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class)) != null) {
            scopes.add(parent);
            place = parent;
        }
        if (scopes.size() == 1) {
            GrMethod owner = (GrMethod)scopes.get(0);
            PsiMethod toSearchFor = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)owner, (String)RefactoringBundle.message((String)"to.refactor"));
            if (toSearchFor == null) {
                return;
            }
            CreateParameterFromUsageFix.showDialog(toSearchFor, ref, project);
        } else if (scopes.size() > 1) {
            this.myEnclosingMethodsPopup = MethodOrClosureScopeChooser.create(scopes, editor, this, new PairFunction<GrParametersOwner, PsiElement, Object>(){

                public Object fun(GrParametersOwner owner, PsiElement element) {
                    CreateParameterFromUsageFix.showDialog((PsiMethod)owner, ref, project);
                    return null;
                }
            });
            this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
        }
    }

    private static void showDialog(final PsiMethod method, final GrReferenceExpression ref, final Project project) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                PsiType type;
                if (project.isDisposed()) {
                    return;
                }
                String name = ref.getReferenceName();
                List<PsiType> types = GroovyExpectedTypesProvider.getDefaultExpectedTypes(ref);
                PsiType unboxed = types.isEmpty() ? null : TypesUtil.unboxPrimitiveTypeWrapper(types.get(0));
                Object object = type = unboxed != null ? unboxed : PsiType.getJavaLangObject((PsiManager)ref.getManager(), (GlobalSearchScope)ref.getResolveScope());
                if (method instanceof GrMethod) {
                    GrMethodDescriptor descriptor = new GrMethodDescriptor((GrMethod)method);
                    GrChangeSignatureDialog dialog = new GrChangeSignatureDialog(project, descriptor, true, ref);
                    List parameters = dialog.getParameters();
                    parameters.add(CreateParameterFromUsageFix.createParameterInfo(name, type));
                    dialog.setParameterInfos(parameters);
                    dialog.show();
                } else if (method != null) {
                    JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(project, method, false, (PsiElement)ref);
                    ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(ParameterInfoImpl.fromMethod((PsiMethod)method)));
                    ParameterInfoImpl parameterInfo = new ParameterInfoImpl(-1, name, type, PsiTypesUtil.getDefaultValueOfType((PsiType)type), false);
                    if (!method.isVarArgs()) {
                        parameterInfos.add(parameterInfo);
                    } else {
                        parameterInfos.add(parameterInfos.size() - 1, parameterInfo);
                    }
                    dialog.setParameterInfos(parameterInfos);
                    dialog.show();
                }
            }
        });
    }

    private static GrParameterInfo createParameterInfo(String name, PsiType type) {
        String notNullName = name != null ? name : "";
        String defaultValueText = GroovyToJavaGenerator.getDefaultValueText(type.getCanonicalText());
        return new GrParameterInfo(notNullName, defaultValueText, "", type, -1, false);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

