/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMergeCommand {
    private static final Logger LOG = Logger.getInstance((String)HgMergeCommand.class.getName());
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;
    @Nullable
    private String revision;

    public HgMergeCommand(@NotNull Project project, @NotNull HgRepository repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    private void setRevision(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/command/HgMergeCommand", "setRevision"));
        }
        this.revision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HgCommandResult execute() {
        HgPromptCommandExecutor commandExecutor = new HgPromptCommandExecutor(this.project);
        commandExecutor.setShowOutput(true);
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            HgCommandResult result = commandExecutor.executeInCurrentThread(this.repo.getRoot(), "merge", arguments);
            this.repo.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project, (AccessToken)token);
        }
    }

    @Nullable
    public HgCommandResult merge() throws VcsException {
        HgCommandResult commandResult = HgErrorHandler.ensureSuccess(this.execute());
        try {
            HgUtil.markDirectoryDirty(this.project, this.repo.getRoot());
        }
        catch (InvocationTargetException e) {
            HgMergeCommand.throwException(e);
        }
        catch (InterruptedException e) {
            HgMergeCommand.throwException(e);
        }
        return commandResult;
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull String branchName, @NotNull UpdatedFiles updatedFiles) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        HgMergeCommand.mergeWith(repository, branchName, updatedFiles, null);
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull String branchName, final @NotNull UpdatedFiles updatedFiles, final @Nullable Runnable onSuccessHandler) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "org/zmlx/hg4idea/command/HgMergeCommand", "mergeWith"));
        }
        final Project project = repository.getProject();
        final VirtualFile repositoryRoot = repository.getRoot();
        final HgMergeCommand hgMergeCommand = new HgMergeCommand(project, repository);
        hgMergeCommand.setRevision(branchName);
        new Task.Backgroundable(project, "Merging changes..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgMergeCommand$1", "run"));
                }
                try {
                    HgCommandResult result = hgMergeCommand.merge();
                    if (HgErrorUtil.isAncestorMergeError(result)) {
                        VcsNotifier.getInstance((Project)project).notifyMinorWarning("Merging is skipped for " + repositoryRoot.getPresentableName(), "Merging with a working directory ancestor has no effect");
                        return;
                    }
                    new HgConflictResolver(project, updatedFiles).resolve(repositoryRoot);
                    if (HgConflictResolver.findConflicts(project, repositoryRoot).isEmpty() && onSuccessHandler != null) {
                        onSuccessHandler.run();
                    }
                }
                catch (VcsException exception) {
                    if (exception.isWarning()) {
                        VcsNotifier.getInstance((Project)project).notifyWarning("Warning during merge", exception.getMessage());
                    }
                    VcsNotifier.getInstance((Project)project).notifyError("Exception during merge", exception.getMessage());
                }
            }
        }.queue();
    }

    private static void throwException(@NotNull Exception e) throws VcsException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/command/HgMergeCommand", "throwException"));
        }
        String msg = "Exception during marking directory dirty: " + e;
        LOG.info(msg, (Throwable)e);
        throw new VcsException(msg);
    }
}

