/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class SocketServer {
    protected ServerSocket myServerSocket;
    private final Protocol myProtocol;

    public SocketServer(Protocol protocol) {
        this.myProtocol = protocol;
    }

    public int start() throws IOException {
        this.myServerSocket = new ServerSocket(0);
        int port = this.myServerSocket.getLocalPort();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean _continue = true;
                    while (_continue) {
                        Socket socket = SocketServer.this.myServerSocket.accept();
                        try {
                            _continue = SocketServer.this.myProtocol.handleConnection(socket);
                        }
                        finally {
                            socket.close();
                        }
                    }
                }
                catch (SocketException _continue) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return port;
    }

    public void stop() {
        try {
            if (this.myServerSocket != null) {
                this.myServerSocket.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class Protocol {
        private static final int MAX_INPUT_LENGTH = 10000000;
        private static final Logger LOG = Logger.getInstance(Protocol.class);

        public abstract boolean handleConnection(Socket var1) throws IOException;

        protected static byte[] readDataBlock(DataInputStream inputStream) throws IOException {
            int length;
            int origLength = inputStream.readInt();
            if (origLength > 10000000) {
                length = 10000000;
                LOG.info(String.format("Too large input: %d bytes. Reading %s bytes and skipping all other.", origLength, length));
            } else {
                length = origLength;
            }
            byte[] data = new byte[length];
            Protocol.readAsMuchAsAvailable(inputStream, data, length);
            int skipped = inputStream.skipBytes(origLength - length);
            if (skipped > 0) {
                LOG.info(String.format("Skipped %s bytes", skipped));
            }
            return data;
        }

        private static void readAsMuchAsAvailable(DataInputStream inputStream, byte[] data, int maxLength) throws IOException {
            int available;
            int offset = 0;
            while ((available = inputStream.available()) > 0) {
                if (available + offset > maxLength) {
                    inputStream.readFully(data, offset, maxLength - offset);
                    return;
                }
                inputStream.readFully(data, offset, available);
                offset += available;
            }
        }

        protected static void sendDataBlock(DataOutputStream out, byte[] data) throws IOException {
            out.writeInt(data.length);
            out.write(data);
        }
    }
}

