/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;

public abstract class HgReferenceValidator
implements InputValidatorEx {
    protected final HgRepository myRepository;
    protected String myErrorText;

    protected HgReferenceValidator(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgReferenceValidator", "<init>"));
        }
        this.myRepository = repository;
    }

    public boolean checkInput(@Nullable String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (name.contains(":")) {
            this.myErrorText = "Name could not contain colons";
            return false;
        }
        return !this.isReservedWord(name) && !this.hasConflictsWithAnotherNames(name);
    }

    public boolean canClose(@Nullable String name) {
        return this.checkInput(name);
    }

    private boolean isReservedWord(@Nullable String name) {
        this.myErrorText = "tip".equals(name) ? String.format("The name '%s' is reserved.", name) : null;
        return this.myErrorText != null;
    }

    protected abstract boolean hasConflictsWithAnotherNames(@Nullable String var1);

    @Nullable
    public String getErrorText(@Nullable String inputString) {
        return this.myErrorText;
    }
}

