/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.buildfiles;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedBuildFileAttribute {
    private static final Logger LOG = Logger.getInstance((String)("#" + ForcedBuildFileAttribute.class.getName()));
    private static final FileAttribute FRAMEWORK_FILE_ATTRIBUTE = new FileAttribute("forcedBuildFileFrameworkAttribute", 2, false);
    private static final Key<String> FRAMEWORK_FILE_MARKER = Key.create((String)"forcedBuildFileFrameworkAttribute");

    private ForcedBuildFileAttribute() {
    }

    public static boolean belongsToFramework(VirtualFile file, @NotNull String frameworkId) {
        if (frameworkId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkId", "com/intellij/buildfiles/ForcedBuildFileAttribute", "belongsToFramework"));
        }
        return frameworkId.equals(ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getFrameworkIdOfBuildFile(VirtualFile file) {
        if (!(file instanceof NewVirtualFile)) return (String)file.getUserData(FRAMEWORK_FILE_MARKER);
        DataInputStream is = FRAMEWORK_FILE_ATTRIBUTE.readAttribute(file);
        if (is == null) return "";
        try {
            try {
                if (is.available() == 0) {
                    String string = null;
                    return string;
                }
                String string = IOUtil.readString((DataInput)is);
                return string;
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            LOG.error(file.getPath(), (Throwable)e);
        }
        return "";
    }

    public static void forceFileToFramework(VirtualFile file, String frameworkId, boolean value) {
        String existingFrameworkId = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file);
        if (!StringUtil.isEmpty((String)existingFrameworkId) && !frameworkId.equals(existingFrameworkId)) {
            return;
        }
        if (value) {
            ForcedBuildFileAttribute.forceBuildFile(file, frameworkId);
        } else {
            ForcedBuildFileAttribute.forceBuildFile(file, null);
        }
    }

    private static void forceBuildFile(VirtualFile file, @Nullable String value) {
        if (file instanceof NewVirtualFile) {
            DataOutputStream os = FRAMEWORK_FILE_ATTRIBUTE.writeAttribute(file);
            try {
                try {
                    IOUtil.writeString((String)StringUtil.notNullize((String)value), (DataOutput)os);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            file.putUserData(FRAMEWORK_FILE_MARKER, (Object)value);
        }
    }
}

