/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtilBase
extends CodeInsightUtilCore {
    private CodeInsightUtilBase() {
    }

    public boolean prepareFileForWrite(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        final VirtualFile file = psiFile.getVirtualFile();
        final Project project = psiFile.getProject();
        if (ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file})) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
                if (editor != null && editor.getComponent().isDisplayable()) {
                    HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"error.hint.file.is.readonly", (Object[])new Object[]{file.getPresentableUrl()}));
                }
            }
        }, project.getDisposed());
        return false;
    }

    public boolean preparePsiElementForWrite(@Nullable PsiElement element) {
        PsiFile file = element == null ? null : element.getContainingFile();
        return this.prepareFileForWrite(file);
    }

    public boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/CodeInsightUtilBase", "preparePsiElementsForWrite"));
        }
        return this.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public boolean preparePsiElementsForWrite(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/CodeInsightUtilBase", "preparePsiElementsForWrite"));
        }
        if (elements.isEmpty()) {
            return true;
        }
        THashSet files = new THashSet();
        Project project = null;
        for (PsiElement psiElement : elements) {
            PsiFile file;
            if (psiElement == null || (file = psiElement.getContainingFile()) == null || !file.isPhysical()) continue;
            project = file.getProject();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) continue;
            files.add(virtualFile);
        }
        if (!files.isEmpty()) {
            VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)files);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(virtualFiles);
            return !operationStatus.hasReadonlyFiles();
        }
        return true;
    }

    public boolean prepareVirtualFilesForWrite(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareVirtualFilesForWrite"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareVirtualFilesForWrite"));
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
        return !status.hasReadonlyFiles();
    }

    public static boolean prepareEditorForWrite(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/CodeInsightUtilBase", "prepareEditorForWrite"));
        }
        if (!editor.isViewer()) {
            return true;
        }
        CodeInsightUtilBase.showReadOnlyViewWarning(editor);
        return false;
    }

    public static void showReadOnlyViewWarning(Editor editor) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        JComponent component = HintUtil.createInformationLabel("This view is read-only");
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }
}

