/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FileTreeIterator;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor");
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private List<PsiFile> myFiles;
    private boolean myIncludeSubdirs;
    private final String myProgressText;
    private final String myCommandName;
    private Runnable myPostRunnable;
    private boolean myProcessChangedTextOnly;
    protected AbstractLayoutCodeProcessor myPreviousCodeProcessor;
    private List<VirtualFileFilter> myFilters;
    private LayoutCodeInfoCollector myInfoCollector;

    protected AbstractLayoutCodeProcessor(Project project, String commandName, String progressText, boolean processChangedTextOnly) {
        this(project, (Module)null, commandName, progressText, processChangedTextOnly);
    }

    protected AbstractLayoutCodeProcessor(@NotNull AbstractLayoutCodeProcessor previous, @NotNull String commandName, @NotNull String progressText) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (progressText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressText", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = previous.myProject;
        this.myModule = previous.myModule;
        this.myDirectory = previous.myDirectory;
        this.myFile = previous.myFile;
        this.myFiles = previous.myFiles;
        this.myIncludeSubdirs = previous.myIncludeSubdirs;
        this.myProcessChangedTextOnly = previous.myProcessChangedTextOnly;
        this.myPostRunnable = null;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPreviousCodeProcessor = previous;
        this.myFilters = previous.myFilters;
        this.myInfoCollector = previous.myInfoCollector;
    }

    protected AbstractLayoutCodeProcessor(Project project, @Nullable Module module, String commandName, String progressText, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myModule = module;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile file, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myModule = null;
        this.myFile = file;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile[] files, String progressText, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project;
        this.myModule = null;
        this.myFiles = AbstractLayoutCodeProcessor.filterFilesTo(files, new ArrayList<PsiFile>());
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = postRunnable;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    private static List<PsiFile> filterFilesTo(PsiFile[] files, List<PsiFile> list) {
        for (PsiFile file : files) {
            if (!AbstractLayoutCodeProcessor.canBeFormatted(file)) continue;
            list.add(file);
        }
        return list;
    }

    public void setPostRunnable(Runnable postRunnable) {
        this.myPostRunnable = postRunnable;
    }

    @Nullable
    private FutureTask<Boolean> getPreviousProcessorTask(@NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getPreviousProcessorTask"));
        }
        return this.myPreviousCodeProcessor != null ? this.myPreviousCodeProcessor.preprocessFile(file, processChangedTextOnly) : null;
    }

    public void setCollectInfo(boolean isCollectInfo) {
        this.myInfoCollector = isCollectInfo ? new LayoutCodeInfoCollector() : null;
        AbstractLayoutCodeProcessor current = this;
        while (current.myPreviousCodeProcessor != null) {
            current = current.myPreviousCodeProcessor;
            current.myInfoCollector = this.myInfoCollector;
        }
    }

    public void addFileFilter(@NotNull VirtualFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "addFileFilter"));
        }
        this.myFilters.add(filter);
    }

    protected void setProcessChangedTextOnly(boolean value) {
        this.myProcessChangedTextOnly = value;
    }

    @NotNull
    protected abstract FutureTask<Boolean> prepareTask(@NotNull PsiFile var1, boolean var2) throws IncorrectOperationException;

    public FutureTask<Boolean> preprocessFile(@NotNull PsiFile file, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "preprocessFile"));
        }
        final FutureTask<Boolean> previousTask = this.getPreviousProcessorTask(file, processChangedTextOnly);
        final FutureTask<Boolean> currentTask = this.prepareTask(file, processChangedTextOnly);
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (previousTask != null) {
                    previousTask.run();
                    if (!((Boolean)previousTask.get()).booleanValue() || previousTask.isCancelled()) {
                        return false;
                    }
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        currentTask.run();
                    }
                });
                return (Boolean)currentTask.get() != false && !currentTask.isCancelled();
            }
        });
    }

    public void run() {
        if (this.myFile != null) {
            this.runProcessFile(this.myFile);
            return;
        }
        FileTreeIterator iterator = this.myFiles != null ? new FileTreeIterator(this.myFiles) : (this.myProcessChangedTextOnly ? this.buildChangedFilesIterator() : this.buildFileTreeIterator());
        this.runProcessFiles(iterator);
    }

    private FileTreeIterator buildFileTreeIterator() {
        if (this.myDirectory != null) {
            return new FileTreeIterator(this.myDirectory);
        }
        if (this.myFiles != null) {
            return new FileTreeIterator(this.myFiles);
        }
        if (this.myModule != null) {
            return new FileTreeIterator(this.myModule);
        }
        if (this.myProject != null) {
            return new FileTreeIterator(this.myProject);
        }
        return new FileTreeIterator(Collections.<PsiFile>emptyList());
    }

    @NotNull
    private FileTreeIterator buildChangedFilesIterator() {
        List<PsiFile> files = this.getChangedFilesFromContext();
        FileTreeIterator fileTreeIterator = new FileTreeIterator(files);
        if (fileTreeIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "buildChangedFilesIterator"));
        }
        return fileTreeIterator;
    }

    @NotNull
    private List<PsiFile> getChangedFilesFromContext() {
        List<PsiDirectory> dirs = this.getAllSearchableDirsFromContext();
        List<PsiFile> list = FormatChangedTextUtil.getChangedFilesFromDirs(this.myProject, dirs);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getChangedFilesFromContext"));
        }
        return list;
    }

    private List<PsiDirectory> getAllSearchableDirsFromContext() {
        ArrayList dirs = ContainerUtil.newArrayList();
        if (this.myDirectory != null) {
            dirs.add(this.myDirectory);
        } else if (this.myModule != null) {
            List<PsiDirectory> allModuleDirs = FileTreeIterator.collectModuleDirectories(this.myModule);
            dirs.addAll(allModuleDirs);
        } else if (this.myProject != null) {
            List<PsiDirectory> allProjectDirs = FileTreeIterator.collectProjectDirectories(this.myProject);
            dirs.addAll(allProjectDirs);
        }
        return dirs;
    }

    private void runProcessFile(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "runProcessFile"));
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        final Ref writeActionRunnable = new Ref();
        Runnable readAction = new Runnable(){

            @Override
            public void run() {
                if (!AbstractLayoutCodeProcessor.this.checkFileWritable(file)) {
                    return;
                }
                try {
                    FutureTask<Boolean> writeTask = AbstractLayoutCodeProcessor.this.preprocessFile(file, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly);
                    writeActionRunnable.set(writeTask);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        Runnable writeAction = new Runnable(){

            @Override
            public void run() {
                if (writeActionRunnable.isNull()) {
                    return;
                }
                FutureTask task = (FutureTask)writeActionRunnable.get();
                task.run();
                try {
                    task.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        this.runLayoutCodeProcess(readAction, writeAction, false);
    }

    private boolean checkFileWritable(PsiFile file) {
        if (!file.isWritable()) {
            ((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(this.myProject, file.getVirtualFile()).setTitle(CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]))).showLater();
            return false;
        }
        return true;
    }

    @Nullable
    private Runnable createIterativeFileProcessor(final @NotNull FileTreeIterator fileIterator) {
        if (fileIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "createIterativeFileProcessor"));
        }
        return new Runnable(){

            @Override
            public void run() {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(AbstractLayoutCodeProcessor.this.myProject, AbstractLayoutCodeProcessor.this.myCommandName);
                progressTask.setMinIterationTime(100L);
                ReformatFilesTask reformatFilesTask = new ReformatFilesTask(fileIterator);
                reformatFilesTask.setCompositeTask(progressTask);
                progressTask.setTask(reformatFilesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        };
    }

    private void runProcessFiles(final @NotNull FileTreeIterator fileIterator) {
        if (fileIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "runProcessFiles"));
        }
        final Runnable[] resultRunnable = new Runnable[1];
        Runnable readAction = new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractLayoutCodeProcessor.this.createIterativeFileProcessor(fileIterator);
            }
        };
        Runnable writeAction = new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        };
        this.runLayoutCodeProcess(readAction, writeAction, true);
    }

    private static boolean canBeFormatted(PsiFile file) {
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        for (GeneratedSourcesFilter filter : (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions()) {
            if (!filter.isGeneratedSource(virtualFile, file.getProject())) continue;
            return false;
        }
        return true;
    }

    private void runLayoutCodeProcess(final Runnable readAction, final Runnable writeAction, final boolean globalAction) {
        final ProgressWindow progressWindow = new ProgressWindow(true, this.myProject);
        progressWindow.setTitle(this.myCommandName);
        progressWindow.setText(this.myProgressText);
        final ModalityState modalityState = ModalityState.current();
        final Runnable process = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(readAction);
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progressWindow);
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (IndexNotReadyException e) {
                    return;
                }
                Runnable writeRunnable = new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(AbstractLayoutCodeProcessor.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                if (globalAction) {
                                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(AbstractLayoutCodeProcessor.this.myProject);
                                }
                                try {
                                    writeAction.run();
                                    if (AbstractLayoutCodeProcessor.this.myPostRunnable != null) {
                                        ApplicationManager.getApplication().invokeLater(AbstractLayoutCodeProcessor.this.myPostRunnable);
                                    }
                                }
                                catch (IndexNotReadyException indexNotReadyException) {
                                    // empty catch block
                                }
                            }
                        }, AbstractLayoutCodeProcessor.this.myCommandName, null);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    writeRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(writeRunnable, modalityState, AbstractLayoutCodeProcessor.this.myProject.getDisposed());
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        FutureTask<Boolean> runnable2 = this.preprocessFile(this.myFile, this.myProcessChangedTextOnly);
        runnable2.run();
    }

    private boolean acceptedByFilters(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "acceptedByFilters"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        for (VirtualFileFilter filter : this.myFilters) {
            if (filter.accept(file.getVirtualFile())) continue;
            return false;
        }
        return true;
    }

    protected static List<TextRange> getSelectedRanges(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getSelectedRanges"));
        }
        SmartList ranges = new SmartList();
        if (selectionModel.hasSelection()) {
            TextRange range = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            ranges.add(range);
        } else if (selectionModel.hasBlockSelection()) {
            int[] starts = selectionModel.getBlockSelectionStarts();
            int[] ends = selectionModel.getBlockSelectionEnds();
            for (int i = 0; i < starts.length; ++i) {
                ranges.add(TextRange.create((int)starts[i], (int)ends[i]));
            }
        }
        return ranges;
    }

    protected void handleFileTooBigException(Logger logger, FilesTooBigForDiffException e, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "handleFileTooBigException"));
        }
        logger.info("Error while calculating changed ranges for: " + file.getVirtualFile(), (Throwable)e);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Notification notification = new Notification(ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.groupId", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.title", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.text", (Object[])new Object[]{file.getName()}), NotificationType.INFORMATION);
            notification.notify(file.getProject());
        }
    }

    @Nullable
    public LayoutCodeInfoCollector getInfoCollector() {
        return this.myInfoCollector;
    }

    private class ReformatFilesTask
    implements SequentialTask {
        private SequentialModalProgressTask myCompositeTask;
        private final FileTreeIterator myFileTreeIterator;
        private final FileTreeIterator myCountingIterator;
        private int myTotalFiles;
        private int myFilesProcessed;
        private boolean myStopFormatting;
        private boolean myFilesCountingFinished;

        ReformatFilesTask(FileTreeIterator fileIterator) {
            if (fileIterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "<init>"));
            }
            this.myTotalFiles = 0;
            this.myFilesProcessed = 0;
            this.myFileTreeIterator = fileIterator;
            this.myCountingIterator = new FileTreeIterator(fileIterator);
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.myStopFormatting || !this.myFileTreeIterator.hasNext();
        }

        private void countingIteration() {
            if (this.myCountingIterator.hasNext()) {
                this.myCountingIterator.next();
                ++this.myTotalFiles;
            } else {
                this.myFilesCountingFinished = true;
            }
        }

        public boolean iteration() {
            if (this.myStopFormatting) {
                return true;
            }
            if (!this.myFilesCountingFinished) {
                this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.prepare.progress.text", (Object[])new Object[0]), "");
                this.countingIteration();
                return true;
            }
            this.updateIndicatorFraction(this.myFilesProcessed);
            if (this.myFileTreeIterator.hasNext()) {
                final PsiFile file = this.myFileTreeIterator.next();
                ++this.myFilesProcessed;
                if (file.isWritable() && AbstractLayoutCodeProcessor.canBeFormatted(file) && AbstractLayoutCodeProcessor.this.acceptedByFilters(file)) {
                    this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.process.progress.text", (Object[])new Object[0]), this.getPresentablePath(file));
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            DumbService.getInstance((Project)AbstractLayoutCodeProcessor.this.myProject).withAlternativeResolveEnabled(new Runnable(){

                                @Override
                                public void run() {
                                    ReformatFilesTask.this.performFileProcessing(file);
                                }
                            });
                        }
                    });
                }
            }
            return true;
        }

        private void performFileProcessing(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "performFileProcessing"));
            }
            FutureTask<Boolean> task = AbstractLayoutCodeProcessor.this.preprocessFile(file, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly);
            task.run();
            try {
                if (!task.get().booleanValue() || task.isCancelled()) {
                    this.myStopFormatting = true;
                }
            }
            catch (InterruptedException e) {
                LOG.error("Got unexpected exception during formatting", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Got unexpected exception during formatting", (Throwable)e);
            }
        }

        private void updateIndicatorText(@NotNull String upperLabel, @NotNull String downLabel) {
            if (upperLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperLabel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "updateIndicatorText"));
            }
            if (downLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downLabel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "updateIndicatorText"));
            }
            ProgressIndicator indicator = this.myCompositeTask.getIndicator();
            if (indicator != null) {
                indicator.setText(upperLabel);
                indicator.setText2(downLabel);
            }
        }

        private String getPresentablePath(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "getPresentablePath"));
            }
            VirtualFile vFile = file.getVirtualFile();
            return vFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)AbstractLayoutCodeProcessor.this.myProject) : file.getName();
        }

        private void updateIndicatorFraction(int processed) {
            ProgressIndicator indicator = this.myCompositeTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)processed / (double)this.myTotalFiles);
            }
        }

        public void stop() {
            this.myStopFormatting = true;
        }

        public void setCompositeTask(@Nullable SequentialModalProgressTask compositeTask) {
            this.myCompositeTask = compositeTask;
        }
    }
}

