/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.StringComboboxEditor;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class ComboEditorCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JComboBox comboBox;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/ComboEditorCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/ComboEditorCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getInvocationCount() == 0) {
            return;
        }
        PsiFile file = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document != null && (comboBox = (JComboBox)document.getUserData(StringComboboxEditor.COMBO_BOX_KEY)) != null) {
            String substring = document.getText().substring(0, parameters.getOffset());
            boolean plainPrefixMatcher = Boolean.TRUE.equals(document.getUserData(StringComboboxEditor.USE_PLAIN_PREFIX_MATCHER));
            CompletionResultSet resultSet = plainPrefixMatcher ? result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(substring)) : result2.withPrefixMatcher(substring);
            int count = comboBox.getItemCount();
            for (int i = 0; i < count; ++i) {
                Object o = comboBox.getItemAt(i);
                if (!(o instanceof String)) continue;
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)((String)o)).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Document document = context.getEditor().getDocument();
                        document.deleteString(context.getEditor().getCaretModel().getOffset(), document.getTextLength());
                    }
                }), (double)(count - i)));
            }
            result2.stopHere();
        }
    }
}

