/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChainLookupElement
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    public static final Key<Boolean> CHAIN_QUALIFIER = Key.create((String)"CHAIN_QUALIFIER");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaChainLookupElement");
    public static final ClassConditionKey<JavaChainLookupElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaChainLookupElement.class);
    private final LookupElement myQualifier;

    public JavaChainLookupElement(LookupElement qualifier, LookupElement main) {
        super(main);
        this.myQualifier = qualifier;
    }

    @NotNull
    public String getLookupString() {
        String string = this.maybeAddParentheses(this.myQualifier.getLookupString()) + "." + this.getDelegate().getLookupString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaChainLookupElement", "getLookupString"));
        }
        return string;
    }

    public LookupElement getQualifier() {
        return this.myQualifier;
    }

    public Set<String> getAllLookupStrings() {
        Set strings = this.getDelegate().getAllLookupStrings();
        THashSet result2 = new THashSet();
        result2.addAll((Collection)strings);
        result2.add((Object)this.getLookupString());
        return result2;
    }

    @NotNull
    public String toString() {
        String string = this.maybeAddParentheses(this.myQualifier.toString()) + "." + this.getDelegate();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaChainLookupElement", "toString"));
        }
        return string;
    }

    private String maybeAddParentheses(String s) {
        return this.getQualifierObject() instanceof PsiMethod ? s + "()" : s;
    }

    @Nullable
    private Object getQualifierObject() {
        Object qObject = this.myQualifier.getObject();
        if (qObject instanceof ResolveResult) {
            qObject = ((ResolveResult)qObject).getElement();
        }
        return qObject;
    }

    public boolean isValid() {
        return super.isValid() && this.myQualifier.isValid();
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        LookupElementPresentation qualifierPresentation = new LookupElementPresentation();
        this.myQualifier.renderElement(qualifierPresentation);
        String name = this.maybeAddParentheses(qualifierPresentation.getItemText());
        String qualifierText = this.myQualifier.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null ? "(" + name + ")" : name;
        presentation.setItemText(qualifierText + "." + presentation.getItemText());
        if (this.myQualifier instanceof JavaPsiClassReferenceElement) {
            String locationString = ((JavaPsiClassReferenceElement)this.myQualifier).getLocationString();
            presentation.setTailText(StringUtil.notNullize((String)presentation.getTailText()) + locationString);
        }
    }

    public void handleInsert(InsertionContext context) {
        char atTail;
        Document document = context.getEditor().getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)";");
        this.myQualifier.putUserData(CHAIN_QUALIFIER, (Object)true);
        InsertionContext qualifierContext = CompletionUtil.emulateInsertion(context, context.getStartOffset(), this.myQualifier);
        OffsetKey oldStart = context.trackOffset(context.getStartOffset(), false);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
        int start = CharArrayUtil.shiftForward((CharSequence)context.getDocument().getCharsSequence(), (int)context.getStartOffset(), (String)" \t\n");
        if (this.shouldParenthesizeQualifier(context.getFile(), start, qualifierContext.getTailOffset())) {
            String space = CodeStyleSettingsManager.getSettings((Project)qualifierContext.getProject()).SPACE_WITHIN_PARENTHESES ? " " : "";
            document.insertString(start, (CharSequence)("(" + space));
            document.insertString(qualifierContext.getTailOffset(), (CharSequence)(space + ")"));
        }
        if ((atTail = document.getCharsSequence().charAt(context.getTailOffset() - 1)) != ';') {
            return;
        }
        document.replaceString(context.getTailOffset() - 1, context.getTailOffset(), (CharSequence)".");
        CompletionUtil.emulateInsertion(this.getDelegate(), context.getTailOffset(), context);
        context.commitDocument();
        int formatStart = context.getOffset(oldStart);
        int formatEnd = context.getTailOffset();
        if (formatStart >= 0 && formatEnd >= 0) {
            CodeStyleManager.getInstance((Project)context.getProject()).reformatText(context.getFile(), formatStart, formatEnd);
        }
    }

    protected boolean shouldParenthesizeQualifier(PsiFile file, int startOffset, int endOffset) {
        PsiElement element = file.findElementAt(startOffset);
        if (element == null) {
            return false;
        }
        PsiElement last = element;
        while (element != null && element.getTextRange().getStartOffset() >= startOffset && element.getTextRange().getEndOffset() <= endOffset && !(element instanceof PsiExpressionStatement)) {
            last = element;
            element = element.getParent();
        }
        PsiExpression expr = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)last, PsiExpression.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (expr == null) {
            return false;
        }
        if (expr.getTextRange().getEndOffset() > endOffset) {
            return true;
        }
        return !(expr instanceof PsiJavaCodeReferenceElement) && !(expr instanceof PsiMethodCallExpression) && !(expr instanceof PsiNewExpression) && !(expr instanceof PsiArrayAccessExpression);
    }

    @NotNull
    private LookupElement getComparableQualifier() {
        CastingLookupElementDecorator casting = (CastingLookupElementDecorator)this.myQualifier.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY);
        LookupElement lookupElement = casting == null ? this.myQualifier : casting.getDelegate();
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaChainLookupElement", "getComparableQualifier"));
        }
        return lookupElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getComparableQualifier().equals(((JavaChainLookupElement)o).getComparableQualifier());
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.getComparableQualifier().hashCode();
    }

    @Override
    public PsiType getType() {
        Object object = this.getObject();
        if (object instanceof PsiMember) {
            return JavaCompletionUtil.getQualifiedMemberReferenceType(JavaCompletionUtil.getLookupElementType(this.myQualifier), (PsiMember)object);
        }
        return ((PsiVariable)object).getType();
    }
}

