/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeToAppendFix
implements IntentionAction {
    private final IElementType myTokenType;
    private final PsiType myLhsType;
    private final PsiAssignmentExpression myAssignmentExpression;

    public ChangeToAppendFix(@NotNull IElementType eqOpSign, @NotNull PsiType lType, @NotNull PsiAssignmentExpression assignmentExpression) {
        if (eqOpSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eqOpSign", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        if (assignmentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        this.myTokenType = eqOpSign;
        this.myLhsType = lType;
        this.myAssignmentExpression = assignmentExpression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.to.append.text", ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getRExpression(), this.myLhsType.equalsToText("java.lang.Appendable"), new StringBuilder(this.myAssignmentExpression.getLExpression().getText())));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.to.append.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "isAvailable"));
        }
        return JavaTokenType.PLUSEQ == this.myTokenType && this.myAssignmentExpression.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myAssignmentExpression) && (this.myLhsType.equalsToText("java.lang.StringBuilder") || this.myLhsType.equalsToText("java.lang.StringBuffer") || this.myLhsType.equalsToText("java.lang.Appendable"));
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getLExpression(), this.myAssignmentExpression.getRExpression());
        if (appendExpression == null) {
            return;
        }
        this.myAssignmentExpression.replace((PsiElement)appendExpression);
    }
}

