/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLocalVarFromInstanceofAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalVarFromInstanceofAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction", "isAvailable"));
        }
        PsiInstanceOfExpression instanceOfExpression = CreateLocalVarFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        if (instanceOfExpression == null) {
            return false;
        }
        PsiTypeElement checkType = instanceOfExpression.getCheckType();
        if (checkType == null) {
            return false;
        }
        PsiExpression operand = instanceOfExpression.getOperand();
        PsiType operandType = operand.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType)) {
            return false;
        }
        PsiType type = checkType.getType();
        String castTo = type.getPresentableText();
        this.setText(QuickFixBundle.message("create.local.from.instanceof.usage.text", castTo, operand.getText()));
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)instanceOfExpression, PsiStatement.class);
        boolean insideIf = statement instanceof PsiIfStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiIfStatement)statement).getCondition(), (PsiElement)instanceOfExpression, (boolean)false);
        boolean insideWhile = statement instanceof PsiWhileStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiWhileStatement)statement).getCondition(), (PsiElement)instanceOfExpression, (boolean)false);
        return (insideIf || insideWhile) && !CreateLocalVarFromInstanceofAction.isAlreadyCastedTo(type, instanceOfExpression, statement);
    }

    private static boolean isAlreadyCastedTo(PsiType type, PsiInstanceOfExpression instanceOfExpression, PsiStatement statement) {
        boolean negated = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression);
        PsiStatement anchor = null;
        if (negated) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                Object[] statements = ((PsiCodeBlock)parent).getStatements();
                int i = ArrayUtil.find((Object[])statements, (Object)statement);
                anchor = i != -1 && i < statements.length - 1 ? statements[i + 1] : null;
            }
        } else {
            PsiStatement psiStatement = anchor = statement instanceof PsiIfStatement ? ((PsiIfStatement)statement).getThenBranch() : ((PsiWhileStatement)statement).getBody();
        }
        if (anchor instanceof PsiBlockStatement) {
            anchor = ((PsiBlockStatement)anchor).getCodeBlock();
        }
        if (anchor instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)anchor).getStatements();
            if (statements.length == 0) {
                return false;
            }
            anchor = statements[0];
        }
        if (anchor instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements;
            for (PsiElement element : declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()) {
                PsiType castType;
                PsiTypeElement castTypeElement;
                PsiExpression initializer;
                if (!(element instanceof PsiLocalVariable) || !((initializer = ((PsiLocalVariable)element).getInitializer()) instanceof PsiTypeCastExpression) || (castTypeElement = ((PsiTypeCastExpression)initializer).getCastType()) == null || !(castType = castTypeElement.getType()).equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    static PsiInstanceOfExpression getInstanceOfExpressionAtCaret(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiInstanceOfExpression expression = (PsiInstanceOfExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiInstanceOfExpression.class);
        if (expression != null) {
            return expression;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiWhileStatement.class});
        if (statement instanceof PsiIfStatement) {
            PsiExpression condition = ((PsiIfStatement)statement).getCondition();
            return CreateLocalVarFromInstanceofAction.retrieveInstanceOfFromCondition(editor, element, statement, condition);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiExpression condition = ((PsiWhileStatement)statement).getCondition();
            return CreateLocalVarFromInstanceofAction.retrieveInstanceOfFromCondition(editor, element, statement, condition);
        }
        return null;
    }

    @Nullable
    private static PsiInstanceOfExpression retrieveInstanceOfFromCondition(Editor editor, PsiElement element, PsiStatement statement, PsiExpression condition) {
        if (condition instanceof PsiInstanceOfExpression) {
            if (CreateLocalVarFromInstanceofAction.atSameLine(condition, editor) || CreateLocalVarFromInstanceofAction.insideEmptyBlockOrRef(statement, element, (PsiInstanceOfExpression)condition)) {
                return (PsiInstanceOfExpression)condition;
            }
        } else if (condition instanceof PsiPolyadicExpression) {
            PsiExpression[] operands = ((PsiPolyadicExpression)condition).getOperands();
            if (((PsiPolyadicExpression)condition).getOperationTokenType() == JavaTokenType.ANDAND) {
                PsiInstanceOfExpression expr = null;
                for (PsiExpression operand : operands) {
                    if (!(operand instanceof PsiInstanceOfExpression)) continue;
                    if (expr != null) {
                        expr = null;
                        break;
                    }
                    expr = (PsiInstanceOfExpression)operand;
                }
                if (expr != null && CreateLocalVarFromInstanceofAction.insideEmptyBlockOrRef(statement, element, expr)) {
                    return expr;
                }
            }
        }
        return null;
    }

    private static boolean insideEmptyBlockOrRef(PsiStatement stmt, PsiElement elementAtCaret, PsiInstanceOfExpression instanceOfExpression) {
        PsiBlockStatement block = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiBlockStatement.class);
        if (block != null && block.getParent() == stmt) {
            PsiStatement[] statements = block.getCodeBlock().getStatements();
            if (statements.length == 0) {
                return true;
            }
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                return CreateLocalVarFromInstanceofAction.replaceReference(instanceOfExpression, (PsiExpressionStatement)statements[0]);
            }
        }
        return false;
    }

    private static boolean replaceReference(PsiInstanceOfExpression instanceOfExpression, PsiExpressionStatement statement) {
        if (CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression)) {
            return false;
        }
        PsiExpression expression = statement.getExpression();
        PsiExpression operand = instanceOfExpression.getOperand();
        return operand instanceof PsiReferenceExpression && expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand).resolve() == ((PsiReferenceExpression)expression).resolve();
    }

    private static boolean atSameLine(PsiExpression condition, Editor editor) {
        int line = editor.getCaretModel().getLogicalPosition().line;
        return editor.getDocument().getLineNumber(condition.getTextOffset()) == line;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateLocalVarFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        assert (instanceOfExpression.getContainingFile() == file) : instanceOfExpression.getContainingFile() + "; file=" + file;
        try {
            PsiStatement statementInside = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression) ? null : CreateLocalVarFromInstanceofAction.getExpressionStatementInside(file, editor, instanceOfExpression.getOperand());
            PsiDeclarationStatement decl = CreateLocalVarFromInstanceofAction.createLocalVariableDeclaration(instanceOfExpression, statementInside);
            if (decl == null) {
                return;
            }
            decl = (PsiDeclarationStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)decl);
            decl = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(decl);
            PsiLocalVariable localVariable = (PsiLocalVariable)decl.getDeclaredElements()[0];
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)localVariable);
            builder.setEndVariableAfter((PsiElement)localVariable.getNameIdentifier());
            Template template = CreateLocalVarFromInstanceofAction.generateTemplate(project, localVariable.getInitializer(), localVariable.getType());
            Editor newEditor = CreateFromUsageBaseFix.positionCursor(project, file, (PsiElement)localVariable.getNameIdentifier());
            if (newEditor == null) {
                return;
            }
            TextRange range = localVariable.getNameIdentifier().getTextRange();
            newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            CreateFromUsageBaseFix.startTemplate(newEditor, template, project, new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            CaretModel caretModel = editor.getCaretModel();
                            PsiElement elementAt = file.findElementAt(caretModel.getOffset());
                            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiDeclarationStatement.class);
                            if (declarationStatement != null) {
                                caretModel.moveToOffset(declarationStatement.getTextRange().getEndOffset());
                            }
                            new EnterAction().actionPerformed(editor, DataManager.getInstance().getDataContext());
                        }
                    });
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    protected static PsiStatement getExpressionStatementInside(PsiFile file, Editor editor, @NotNull PsiExpression operand) {
        PsiStatement[] statements;
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction", "getExpressionStatementInside"));
        }
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        PsiBlockStatement blockStatement = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiBlockStatement.class);
        if (blockStatement == null) {
            PsiIfStatement ifStm = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiIfStatement.class);
            if (ifStm != null) {
                PsiStatement thenBranch = ifStm.getThenBranch();
                if (thenBranch instanceof PsiBlockStatement) {
                    blockStatement = (PsiBlockStatement)thenBranch;
                }
            } else {
                PsiStatement body;
                PsiWhileStatement whileStatement = (PsiWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiWhileStatement.class);
                if (whileStatement != null && (body = whileStatement.getBody()) instanceof PsiBlockStatement) {
                    blockStatement = (PsiBlockStatement)body;
                }
            }
        }
        if (blockStatement != null && (statements = blockStatement.getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiExpressionStatement)statements[0]).getExpression(), (PsiElement)operand)) {
            return statements[0];
        }
        return null;
    }

    @Nullable
    private static PsiDeclarationStatement createLocalVariableDeclaration(PsiInstanceOfExpression instanceOfExpression, PsiStatement statementInside) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)instanceOfExpression.getProject()).getElementFactory();
        PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(a)b", (PsiElement)instanceOfExpression);
        PsiType castType = instanceOfExpression.getCheckType().getType();
        cast.getCastType().replace((PsiElement)factory.createTypeElement(castType));
        cast.getOperand().replace((PsiElement)instanceOfExpression.getOperand());
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement("xxx", castType, (PsiExpression)cast);
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        if (createFinals != null) {
            PsiElement[] declaredElements = decl.getDeclaredElements();
            LOG.assertTrue(declaredElements.length == 1);
            LOG.assertTrue(declaredElements[0] instanceof PsiLocalVariable);
            PsiModifierList modifierList = ((PsiLocalVariable)declaredElements[0]).getModifierList();
            LOG.assertTrue(modifierList != null);
            modifierList.setModifierProperty("final", createFinals.booleanValue());
        }
        if (statementInside != null) {
            return (PsiDeclarationStatement)statementInside.replace((PsiElement)decl);
        }
        return (PsiDeclarationStatement)CreateLocalVarFromInstanceofAction.insertAtAnchor(instanceOfExpression, (PsiElement)decl);
    }

    @Nullable
    static PsiElement insertAtAnchor(PsiInstanceOfExpression instanceOfExpression, PsiElement toInsert) throws IncorrectOperationException {
        boolean negated = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression);
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)instanceOfExpression, PsiStatement.class);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)toInsert.getProject()).getElementFactory();
        PsiIfStatement anchorAfter = null;
        PsiBlockStatement emptyBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)instanceOfExpression);
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (negated) {
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch == null) {
                    anchorAfter = ifStatement;
                } else if (!(elseBranch instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)elseBranch);
                    PsiBlockStatement newBranch = (PsiBlockStatement)elseBranch.replace((PsiElement)emptyBlockStatement);
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getElseElement(), newBranch);
                    anchorAfter = newBranch.getCodeBlock().getLBrace();
                } else {
                    anchorAfter = ((PsiBlockStatement)elseBranch).getCodeBlock().getLBrace();
                }
            } else {
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (thenBranch == null) {
                    ifStatement.setThenBranch((PsiStatement)emptyBlockStatement);
                    PsiBlockStatement then2 = (PsiBlockStatement)ifStatement.getThenBranch();
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getCondition(), then2);
                    anchorAfter = then2.getCodeBlock().getLBrace();
                } else if (!(thenBranch instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)thenBranch);
                    PsiBlockStatement newBranch = (PsiBlockStatement)thenBranch.replace((PsiElement)emptyBlockStatement);
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getCondition(), newBranch);
                    anchorAfter = newBranch.getCodeBlock().getLBrace();
                } else {
                    PsiJavaToken lBrace = ((PsiBlockStatement)thenBranch).getCodeBlock().getLBrace();
                    if (lBrace != null) {
                        PsiElement nextSibling = PsiTreeUtil.skipSiblingsForward((PsiElement)lBrace, (Class[])new Class[]{PsiWhiteSpace.class});
                        Object object = anchorAfter = nextSibling instanceof PsiComment ? PsiTreeUtil.skipSiblingsForward((PsiElement)nextSibling, (Class[])new Class[]{PsiComment.class}) : lBrace;
                    }
                }
            }
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            LOG.assertTrue(whileStatement.getLParenth() != null);
            LOG.assertTrue(whileStatement.getCondition() != null);
            if (whileStatement.getRParenth() == null) {
                PsiWhileStatement statementPattern = (PsiWhileStatement)factory.createStatementFromText("while (){}", (PsiElement)instanceOfExpression);
                whileStatement.addAfter((PsiElement)statementPattern.getRParenth(), (PsiElement)whileStatement.getCondition());
            }
            if (negated) {
                anchorAfter = whileStatement;
            } else {
                PsiStatement body = whileStatement.getBody();
                if (body == null) {
                    whileStatement.add((PsiElement)emptyBlockStatement);
                } else if (!(body instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)body);
                    whileStatement.getBody().replace((PsiElement)emptyBlockStatement);
                }
                anchorAfter = ((PsiBlockStatement)whileStatement.getBody()).getCodeBlock().getLBrace();
            }
        }
        if (anchorAfter == null) {
            return null;
        }
        return anchorAfter.getParent().addAfter(toInsert, anchorAfter);
    }

    private static void reformatNewCodeBlockBraces(PsiElement start, PsiBlockStatement end) throws IncorrectOperationException {
        CodeStyleManager.getInstance((Project)end.getProject()).reformatRange((PsiElement)end.getContainingFile(), start.getTextRange().getEndOffset(), end.getTextRange().getStartOffset());
    }

    protected static boolean isNegated(PsiInstanceOfExpression instanceOfExpression) {
        PsiElement element = instanceOfExpression.getParent();
        while (element instanceof PsiParenthesizedExpression) {
            element = element.getParent();
        }
        return element instanceof PsiPrefixExpression && ((PsiPrefixExpression)element).getOperationTokenType() == JavaTokenType.EXCL;
    }

    private static Template generateTemplate(Project project, PsiExpression initializer, PsiType type) {
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, initializer, type);
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String name : suggestedNameInfo.names) {
            if (!PsiUtil.isVariableNameUnique((String)name, (PsiElement)initializer)) continue;
            uniqueNames.add(name);
        }
        if (uniqueNames.isEmpty() && suggestedNameInfo.names.length != 0) {
            String baseName = suggestedNameInfo.names[0];
            String name = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(baseName, (PsiElement)initializer, true);
            uniqueNames.add(name);
        }
        LinkedHashSet<LookupElementBuilder> itemSet = new LinkedHashSet<LookupElementBuilder>();
        for (String name : uniqueNames) {
            itemSet.add(LookupElementBuilder.create((String)name));
        }
        final LookupElement[] lookupItems = itemSet.toArray(new LookupElement[itemSet.size()]);
        TextResult result2 = uniqueNames.isEmpty() ? null : new TextResult((String)uniqueNames.get(0));
        Expression expr = new Expression((Result)result2){
            final /* synthetic */ Result val$result;
            {
                this.val$result = result2;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems.length > 1 ? lookupItems : null;
            }

            public Result calculateResult(ExpressionContext context) {
                return this.val$result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.val$result;
            }
        };
        template.addVariable("", expr, expr, true);
        return template;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.local.from.instanceof.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction", "getFamilyName"));
        }
        return string;
    }
}

