/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchFix
implements IntentionAction {
    private final PsiParameter myCatchParameter;

    public DeleteCatchFix(@NotNull PsiParameter myCatchParameter) {
        if (myCatchParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myCatchParameter", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix", "<init>"));
        }
        this.myCatchParameter = myCatchParameter;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter.getType()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.catch.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix", "isAvailable"));
        }
        return this.myCatchParameter.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myCatchParameter.getContainingFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myCatchParameter.getContainingFile())) {
            return;
        }
        PsiTryStatement tryStatement = ((PsiCatchSection)this.myCatchParameter.getDeclarationScope()).getTryStatement();
        if (tryStatement.getCatchBlocks().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null) {
            PsiElement firstElement;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            PsiCodeBlock lastAddedStatement = null;
            if (tryBlock != null && (firstElement = tryBlock.getFirstBodyElement()) != null) {
                PsiElement tryParent = tryStatement.getParent();
                if (tryParent instanceof PsiCodeBlock) {
                    PsiElement lastBodyElement = tryBlock.getLastBodyElement();
                    assert (lastBodyElement != null) : tryBlock.getText();
                    tryParent.addRangeBefore(firstElement, lastBodyElement, (PsiElement)tryStatement);
                    for (lastAddedStatement = tryStatement.getPrevSibling(); lastAddedStatement != null && (lastAddedStatement instanceof PsiWhiteSpace || lastAddedStatement.getTextLength() == 0); lastAddedStatement = lastAddedStatement.getPrevSibling()) {
                    }
                } else {
                    tryParent.addBefore((PsiElement)tryBlock, (PsiElement)tryStatement);
                    lastAddedStatement = tryBlock;
                }
            }
            tryStatement.delete();
            if (lastAddedStatement != null) {
                editor.getCaretModel().moveToOffset(lastAddedStatement.getTextRange().getEndOffset());
            }
            return;
        }
        PsiElement catchSection = this.myCatchParameter.getParent();
        assert (catchSection instanceof PsiCatchSection) : catchSection;
        PsiElement previousElement = catchSection.getPrevSibling();
        while (previousElement instanceof PsiWhiteSpace) {
            previousElement = previousElement.getPrevSibling();
        }
        catchSection.delete();
        if (previousElement != null) {
            editor.getCaretModel().moveToOffset(previousElement.getTextRange().getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

