/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class QualifyWithThisFix
implements IntentionAction {
    private final PsiClass myContainingClass;
    private final PsiElement myExpression;

    public QualifyWithThisFix(@NotNull PsiClass containingClass, @NotNull PsiElement expression) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "<init>"));
        }
        this.myContainingClass = containingClass;
        this.myExpression = expression;
    }

    @NotNull
    public String getText() {
        String string = "Qualify with " + this.myContainingClass.getName() + ".this";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyWithThisFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression(PsiManager.getInstance((Project)project), this.myContainingClass);
        ((PsiReferenceExpression)this.myExpression).setQualifierExpression((PsiExpression)thisExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

