/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix");
    private final String myNewName;
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        super((PsiElement)element);
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message((String)"rename.public.class.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "<init>"));
        }
        super((PsiElement)element);
        this.myNewName = newName;
        this.myText = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(final @NotNull Project project, final @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, final @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "invoke"));
        }
        if (this.isAvailable(project, null, file)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix$1", "run"));
                    }
                    LOG.assertTrue(file == startElement.getContainingFile());
                    if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                        return;
                    }
                    RenameProcessor processor2 = new RenameProcessor(project, startElement, RenameElementFix.this.myNewName, false, false);
                    processor2.run();
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix", "isAvailable"));
        }
        if (!startElement.isValid()) {
            return false;
        }
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(file.getLanguage());
        return namesValidator != null && namesValidator.isIdentifier(this.myNewName, project);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

