/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanExpressionFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpression");
    public static final String FAMILY_NAME = QuickFixBundle.message("simplify.boolean.expression.family", new Object[0]);
    private final Boolean mySubExpressionValue;

    public SimplifyBooleanExpressionFix(@NotNull PsiExpression subExpression, Boolean subExpressionValue) {
        if (subExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subExpression", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "<init>"));
        }
        super((PsiElement)subExpression);
        this.mySubExpressionValue = subExpressionValue;
    }

    @NotNull
    public String getText() {
        PsiExpression expression = this.getSubExpression();
        String string = QuickFixBundle.message("simplify.boolean.expression.text", expression.getText(), this.mySubExpressionValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable() {
        PsiExpression expression = this.getSubExpression();
        return super.isAvailable() && expression != null && expression.isValid() && expression.getManager().isInProject((PsiElement)expression) && !PsiUtil.isAccessedForWriting((PsiExpression)expression);
    }

    public void invoke(final @NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "invoke"));
        }
        if (!this.isAvailable()) {
            return;
        }
        final PsiExpression expression = this.getSubExpression();
        LOG.assertTrue(expression.isValid());
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)expression)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                SimplifyBooleanExpressionFix.simplifyExpression(project, expression, SimplifyBooleanExpressionFix.this.mySubExpressionValue);
            }
        });
    }

    public static void simplifyExpression(Project project, PsiExpression subExpression, Boolean subExpressionValue) {
        PsiExpression expression;
        if (subExpressionValue == null) {
            expression = subExpression;
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression constExpression = factory.createExpressionFromText(Boolean.toString(subExpressionValue), (PsiElement)subExpression);
            expression = (PsiExpression)subExpression.replace((PsiElement)constExpression);
        }
        while (expression.getParent() instanceof PsiExpression) {
            expression = (PsiExpression)expression.getParent();
        }
        SimplifyBooleanExpressionFix.simplifyExpression(expression);
    }

    public static void simplifyIfStatement(PsiExpression expression) throws IncorrectOperationException {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiIfStatement) || ((PsiIfStatement)parent).getCondition() != expression) {
            return;
        }
        if (!(expression instanceof PsiLiteralExpression) || !PsiType.BOOLEAN.equals((Object)expression.getType())) {
            return;
        }
        boolean condition = Boolean.parseBoolean(expression.getText());
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        if (condition) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, ifStatement.getThenBranch());
        } else {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.delete();
            } else {
                SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, elseBranch);
            }
        }
    }

    private static void replaceWithStatements(PsiStatement orig, PsiStatement statement) throws IncorrectOperationException {
        if (statement == null) {
            orig.delete();
            return;
        }
        PsiElement parent = orig.getParent();
        if (parent == null) {
            return;
        }
        if (statement instanceof PsiBlockStatement && parent instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            PsiJavaToken lBrace = codeBlock.getLBrace();
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                PsiElement added = parent.addRangeBefore(children2[1], children2[children2.length - 2], (PsiElement)orig);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((PsiManager)orig.getManager());
                codeStyleManager.reformat(added);
            }
            orig.delete();
        } else {
            orig.replace((PsiElement)statement);
        }
    }

    public static void simplifyExpression(PsiExpression expression) throws IncorrectOperationException {
        PsiElement parent;
        final PsiExpression[] result2 = new PsiExpression[]{(PsiExpression)expression.copy()};
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), true);
        final IncorrectOperationException[] exception = new IncorrectOperationException[]{null};
        result2[0].accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement[] children2;
                for (PsiElement child : children2 = element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.resultExpression != null) {
                    LOG.assertTrue(expressionVisitor.resultExpression.isValid());
                    try {
                        if (expression != result2[0]) {
                            expression.replace((PsiElement)expressionVisitor.resultExpression);
                        } else {
                            result2[0] = expressionVisitor.resultExpression;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PsiExpression newExpression = (PsiExpression)expression.replace((PsiElement)result2[0]);
        if (newExpression instanceof PsiLiteralExpression && (parent = newExpression.getParent()) instanceof PsiAssertStatement && ((PsiLiteralExpression)newExpression).getValue() == Boolean.TRUE) {
            parent.delete();
            return;
        }
        SimplifyBooleanExpressionFix.simplifyIfStatement(newExpression);
    }

    public static boolean canBeSimplified(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix", "canBeSimplified"));
        }
        if (!(expression instanceof PsiConditionalExpression) && !PsiType.BOOLEAN.equals((Object)expression.getType())) {
            return false;
        }
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression.getManager(), false);
        final Ref canBeSimplified = new Ref((Object)Boolean.FALSE);
        expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)canBeSimplified.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                expressionVisitor.clear();
                expression.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.canBeSimplifiedFlag) {
                    canBeSimplified.set((Object)Boolean.TRUE);
                }
            }
        });
        return (Boolean)canBeSimplified.get();
    }

    private PsiExpression getSubExpression() {
        PsiElement element = this.getStartElement();
        return element instanceof PsiExpression ? (PsiExpression)element : null;
    }

    public static Boolean getConstBoolean(PsiExpression operand) {
        if (operand == null) {
            return null;
        }
        if ((operand = PsiUtil.deparenthesizeExpression((PsiExpression)operand)) == null) {
            return null;
        }
        String text = operand.getText();
        return "true".equals(text) ? Boolean.TRUE : ("false".equals(text) ? Boolean.FALSE : null);
    }

    private static class ExpressionVisitor
    extends JavaElementVisitor {
        private PsiExpression resultExpression;
        private final PsiExpression trueExpression;
        private final PsiExpression falseExpression;
        private final boolean isCreateResult;
        boolean canBeSimplifiedFlag;

        private ExpressionVisitor(PsiManager psiManager, boolean createResult) {
            this.isCreateResult = createResult;
            this.trueExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(true)) : null;
            this.falseExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(false)) : null;
        }

        private static PsiExpression createExpression(PsiManager psiManager, @NonNls String text) {
            try {
                return JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createExpressionFromText(text, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private boolean markAndCheckCreateResult() {
            this.canBeSimplifiedFlag = true;
            return this.isCreateResult;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            PsiExpression lExpr = operands[0];
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.XOR == tokenType) {
                boolean negate = false;
                ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
                for (PsiExpression operand : operands) {
                    Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand);
                    if (constBoolean != null) {
                        this.markAndCheckCreateResult();
                        if (constBoolean != Boolean.TRUE) continue;
                        negate = !negate;
                        continue;
                    }
                    expressions.add(operand);
                }
                if (expressions.isEmpty()) {
                    this.resultExpression = negate ? this.trueExpression : this.falseExpression;
                } else {
                    String simplifiedText = StringUtil.join(expressions, (Function)new Function<PsiExpression, String>(){

                        public String fun(PsiExpression expression) {
                            return expression.getText();
                        }
                    }, (String)" ^ ");
                    if (negate) {
                        simplifiedText = expressions.size() > 1 ? "!(" + simplifiedText + ")" : "!" + simplifiedText;
                    }
                    this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(simplifiedText, (PsiElement)expression);
                }
            } else {
                for (int i = 1; i < operands.length; ++i) {
                    Boolean l = SimplifyBooleanExpressionFix.getConstBoolean(lExpr);
                    PsiExpression operand = operands[i];
                    Boolean r = SimplifyBooleanExpressionFix.getConstBoolean(operand);
                    if (l != null) {
                        this.simplifyBinary(tokenType, l, operand);
                    } else if (r != null) {
                        this.simplifyBinary(tokenType, r, lExpr);
                    } else {
                        PsiJavaToken javaToken = expression.getTokenBeforeOperand(operand);
                        if (javaToken != null && !PsiTreeUtil.hasErrorElements((PsiElement)operand) && !PsiTreeUtil.hasErrorElements((PsiElement)lExpr)) {
                            try {
                                this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(lExpr.getText() + javaToken.getText() + operand.getText(), (PsiElement)expression);
                            }
                            catch (IncorrectOperationException e) {
                                this.resultExpression = null;
                            }
                        } else {
                            this.resultExpression = null;
                        }
                    }
                    if (this.resultExpression == null) continue;
                    lExpr = this.resultExpression;
                }
            }
        }

        private void simplifyBinary(IElementType tokenType, Boolean lConstBoolean, PsiExpression rOperand) {
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            if (JavaTokenType.ANDAND == tokenType || JavaTokenType.AND == tokenType) {
                this.resultExpression = lConstBoolean != false ? rOperand : this.falseExpression;
            } else if (JavaTokenType.OROR == tokenType || JavaTokenType.OR == tokenType) {
                this.resultExpression = lConstBoolean != false ? this.trueExpression : rOperand;
            } else if (JavaTokenType.EQEQ == tokenType) {
                this.simplifyEquation(lConstBoolean, rOperand);
            } else if (JavaTokenType.NE == tokenType) {
                PsiPrefixExpression negatedExpression = ExpressionVisitor.createNegatedExpression(rOperand);
                this.resultExpression = negatedExpression;
                this.visitPrefixExpression(negatedExpression);
                this.simplifyEquation(lConstBoolean, this.resultExpression);
            }
        }

        private void simplifyEquation(Boolean constBoolean, PsiExpression otherOperand) {
            if (constBoolean.booleanValue()) {
                this.resultExpression = otherOperand;
            } else {
                PsiPrefixExpression negated = ExpressionVisitor.createNegatedExpression(otherOperand);
                this.resultExpression = negated;
                this.visitPrefixExpression(negated);
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            Boolean condition = SimplifyBooleanExpressionFix.getConstBoolean(expression.getCondition());
            if (condition == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = condition != false ? expression.getThenExpression() : expression.getElseExpression();
        }

        private static PsiPrefixExpression createNegatedExpression(PsiExpression otherOperand) {
            PsiPrefixExpression expression = (PsiPrefixExpression)ExpressionVisitor.createExpression(otherOperand.getManager(), "!(xxx)");
            try {
                expression.getOperand().replace((PsiElement)otherOperand);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return expression;
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            PsiExpression operand = expression.getOperand();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand);
            if (constBoolean == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.EXCL == tokenType) {
                if (!this.markAndCheckCreateResult()) {
                    return;
                }
                this.resultExpression = constBoolean != false ? this.falseExpression : this.trueExpression;
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiExpression subexpr = expression.getExpression();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(subexpr);
            if (constBoolean == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = constBoolean != false ? this.trueExpression : this.falseExpression;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void clear() {
            this.resultExpression = null;
        }
    }
}

