/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingColors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class XmlTagTreeHighlightingUtil {
    private XmlTagTreeHighlightingUtil() {
    }

    static boolean containsTagsWithSameName(PsiElement[] elements) {
        HashSet names = new HashSet();
        for (PsiElement element : elements) {
            String name;
            if (!(element instanceof XmlTag) || names.add(name = ((XmlTag)element).getName())) continue;
            return true;
        }
        return false;
    }

    static boolean isTagTreeHighlightingActive(PsiFile file) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!XmlTagTreeHighlightingUtil.hasXmlViewProvider(file)) {
            return false;
        }
        return WebEditorOptions.getInstance().isTagTreeHighlightingEnabled();
    }

    private static boolean hasXmlViewProvider(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil", "hasXmlViewProvider"));
        }
        for (PsiFile f : file.getViewProvider().getAllFiles()) {
            if (!(f instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil", "makeTransparent"));
        }
        if (backgroundColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundColor", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil", "makeTransparent"));
        }
        int r = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result2 = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result2 < 0) {
            return 0;
        }
        if (result2 > 255) {
            return 255;
        }
        return result2;
    }

    static Color[] getBaseColors() {
        ColorKey[] colorKeys = XmlTagTreeHighlightingColors.getColorKeys();
        Color[] colors = new Color[colorKeys.length];
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorsScheme.getColor(colorKeys[i]);
        }
        return colors;
    }
}

