/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class BraceMatcherBasedSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        FileType fileType;
        VirtualFile file = e.getContainingFile().getVirtualFile();
        FileType fileType2 = fileType = file == null ? null : file.getFileType();
        if (fileType == null) {
            return super.select(e, editorText, cursorOffset, editor);
        }
        int textLength = editorText.length();
        TextRange totalRange = e.getTextRange();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(totalRange.getStartOffset());
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        LinkedList<Trinity> stack = new LinkedList<Trinity>();
        while (!iterator.atEnd() && iterator.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator, editorText, fileType)) {
                stack.addLast(Trinity.create((Object)iterator.getStart(), (Object)iterator.getEnd(), (Object)iterator.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator, editorText, fileType) && !stack.isEmpty()) {
                Trinity last = (Trinity)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last.third, iterator.getTokenType())) {
                    int bodyStart;
                    stack.removeLast();
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(((Integer)last.first).intValue(), iterator.getEnd())));
                    int bodyEnd = iterator.getStart();
                    for (bodyStart = ((Integer)last.second).intValue(); bodyStart < textLength && Character.isWhitespace(editorText.charAt(bodyStart)); ++bodyStart) {
                    }
                    while (bodyEnd > 0 && bodyStart < bodyEnd && Character.isWhitespace(editorText.charAt(bodyEnd - 1))) {
                        --bodyEnd;
                    }
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(bodyStart, bodyEnd)));
                }
            }
            iterator.advance();
        }
        result2.add(e.getTextRange());
        return result2;
    }
}

