/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPasteReferenceProcessor;
import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class JavaCopyPasteReferenceProcessor
extends CopyPasteReferenceProcessor<PsiJavaCodeReferenceElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.JavaCopyPasteReferenceProcessor");

    @Override
    protected void addReferenceData(PsiFile file, int startOffset, PsiElement element, ArrayList<ReferenceData> to) {
        JavaResolveResult resolveResult;
        PsiElement refElement;
        if (element instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)element).isQualified() && (refElement = (resolveResult = ((PsiJavaCodeReferenceElement)element).advancedResolve(false)).getElement()) != null) {
            if (refElement instanceof PsiClass) {
                String qName;
                if (refElement.getContainingFile() != element.getContainingFile() && (qName = ((PsiClass)refElement).getQualifiedName()) != null) {
                    JavaCopyPasteReferenceProcessor.addReferenceData(element, to, startOffset, qName, null);
                }
            } else if (resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) {
                String classQName = ((PsiMember)refElement).getContainingClass().getQualifiedName();
                String name = ((PsiNamedElement)refElement).getName();
                if (classQName != null && name != null) {
                    JavaCopyPasteReferenceProcessor.addReferenceData(element, to, startOffset, classQName, name);
                }
            }
        }
    }

    protected PsiJavaCodeReferenceElement[] findReferencesToRestore(PsiFile file, RangeMarker bounds, ReferenceData[] referenceData) {
        PsiManager manager = file.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper helper = facade.getResolveHelper();
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[referenceData.length];
        for (int i = 0; i < referenceData.length; ++i) {
            PsiElement referent;
            PsiJavaCodeReferenceElement reference;
            TextRange range;
            ReferenceData data = referenceData[i];
            PsiClass refClass = facade.findClass(data.qClassName, file.getResolveScope());
            if (refClass == null) continue;
            int startOffset = data.startOffset + bounds.getStartOffset();
            int endOffset = data.endOffset + bounds.getStartOffset();
            PsiElement element = file.findElementAt(startOffset);
            if (!(element instanceof PsiIdentifier) || !(element.getParent() instanceof PsiJavaCodeReferenceElement) || (range = (reference = (PsiJavaCodeReferenceElement)element.getParent()).getTextRange()).getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            if (data.staticMemberName == null) {
                PsiClass refClass1 = helper.resolveReferencedClass(reference.getText(), (PsiElement)reference);
                if (refClass1 != null && manager.areElementsEquivalent((PsiElement)refClass, (PsiElement)refClass1)) continue;
                refs[i] = reference;
                continue;
            }
            if (!(reference instanceof PsiReferenceExpression) || (referent = this.resolveReferenceIgnoreOverriding((PsiPolyVariantReference)reference)) instanceof PsiNamedElement && data.staticMemberName.equals(((PsiNamedElement)referent).getName()) && referent instanceof PsiMember && ((PsiMember)referent).getContainingClass() != null && data.qClassName.equals(((PsiMember)referent).getContainingClass().getQualifiedName())) continue;
            refs[i] = reference;
        }
        return refs;
    }

    protected void restoreReferences(ReferenceData[] referenceData, PsiJavaCodeReferenceElement[] refs) {
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement reference = refs[i];
            if (reference == null || !reference.isValid()) continue;
            try {
                PsiManager manager = reference.getManager();
                ReferenceData refData = referenceData[i];
                PsiClass refClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(refData.qClassName, reference.getResolveScope());
                if (refClass == null) continue;
                if (refData.staticMemberName == null) {
                    reference.bindToElement((PsiElement)refClass);
                    continue;
                }
                LOG.assertTrue(reference instanceof PsiReferenceExpression);
                ((PsiReferenceExpression)reference).bindToElementViaStaticImport(refClass);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

