/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ReflectionUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElementSignatureProvider
implements ElementSignatureProvider {
    protected static final String ELEMENTS_SEPARATOR = ";";
    protected static final String ELEMENT_TOKENS_SEPARATOR = "#";
    private static final String ESCAPE_CHAR = "\\";
    private static final String[] ESCAPE_FROM = new String[]{"\\", "#", ";"};
    private static final String[] ESCAPE_TO = new String[]{"\\\\", "\\s", "\\h"};

    @Override
    @Nullable
    public PsiElement restoreBySignature(@NotNull PsiFile file, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        PsiFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider", "restoreBySignature"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider", "restoreBySignature"));
        }
        int semicolonIndex = signature.indexOf(ELEMENTS_SEPARATOR);
        if (semicolonIndex >= 0) {
            String parentSignature = signature.substring(semicolonIndex + 1);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Provider '%s'. Restoring parent by signature '%s'...%n", this.getClass().getName(), parentSignature));
            }
            parent = this.restoreBySignature(file, parentSignature, processingInfoStorage);
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Restored parent by signature '%s': %s%n", parentSignature, parent));
            }
            if (parent == null) {
                return null;
            }
            signature = signature.substring(0, semicolonIndex);
        } else {
            parent = file;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, ELEMENT_TOKENS_SEPARATOR);
        String type = tokenizer.nextToken();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Provider '%s'. Restoring target element by signature '%s'. Parent: %s, same as the given parent: %b%n", this.getClass().getName(), signature, parent, parent == file));
        }
        return this.restoreBySignatureTokens(file, (PsiElement)parent, type, tokenizer, processingInfoStorage);
    }

    @Nullable
    protected abstract PsiElement restoreBySignatureTokens(@NotNull PsiFile var1, @NotNull PsiElement var2, @NotNull String var3, @NotNull StringTokenizer var4, @Nullable StringBuilder var5);

    protected static <T extends PsiNamedElement> int getChildIndex(T element, PsiElement parent, String name, Class<T> hisClass) {
        PsiElement[] children2 = parent.getChildren();
        int index = 0;
        for (PsiElement child : children2) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName()))) continue;
            if (namedChild.equals(element)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @Nullable
    protected static <T extends PsiNamedElement> T restoreElementInternal(@NotNull PsiElement parent, String name, int index, @NotNull Class<T> hisClass) {
        PsiElement[] children2;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider", "restoreElementInternal"));
        }
        if (hisClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hisClass", "com/intellij/codeInsight/folding/impl/AbstractElementSignatureProvider", "restoreElementInternal"));
        }
        for (PsiElement child : children2 = parent.getChildren()) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionUtil.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)hisClass.cast(child)).getName()))) continue;
            if (index == 0) {
                return (T)namedChild;
            }
            --index;
        }
        return null;
    }

    protected static String escape(String name) {
        return StringUtil.replace((String)name, (String[])ESCAPE_FROM, (String[])ESCAPE_TO);
    }

    protected static String unescape(String name) {
        return StringUtil.replace((String)name, (String[])ESCAPE_TO, (String[])ESCAPE_FROM);
    }
}

