/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUtil {
    private FoldingUtil() {
    }

    @Nullable
    public static FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUtil", "findFoldRegion"));
        }
        FoldRegion region = editor.getFoldingModel().getFoldRegion(startOffset, endOffset);
        return region != null && region.isValid() ? region : null;
    }

    @Nullable
    public static FoldRegion findFoldRegionStartingAtLine(@NotNull Editor editor, int line) {
        FoldRegion[] regions;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUtil", "findFoldRegionStartingAtLine"));
        }
        if (line < 0 || line >= editor.getDocument().getLineCount()) {
            return null;
        }
        FoldRegion result2 = null;
        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid() || region.getDocument().getLineNumber(region.getStartOffset()) != line) continue;
            if (result2 != null) {
                return null;
            }
            result2 = region;
        }
        return result2;
    }

    public static FoldRegion[] getFoldRegionsAtOffset(Editor editor, int offset) {
        FoldRegion[] allRegions;
        ArrayList<FoldRegion> list = new ArrayList<FoldRegion>();
        for (FoldRegion region : allRegions = editor.getFoldingModel().getAllFoldRegions()) {
            if (region.getStartOffset() > offset || offset > region.getEndOffset()) continue;
            list.add(region);
        }
        FoldRegion[] regions = list.toArray(new FoldRegion[list.size()]);
        Arrays.sort(regions, Collections.reverseOrder(RangeMarker.BY_START_OFFSET));
        return regions;
    }

    public static boolean caretInsideRange(Editor editor, TextRange range) {
        int offset = editor.getCaretModel().getOffset();
        return range.contains(offset) && range.getStartOffset() != offset;
    }

    public static Iterator<FoldRegion> createFoldTreeIterator(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/FoldingUtil", "createFoldTreeIterator"));
        }
        final FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        return new Iterator<FoldRegion>(){
            private int sectionStart;
            private int current;
            private int sectionEnd;
            {
                this.advanceSection();
            }

            private void advanceSection() {
                this.sectionStart = this.sectionEnd;
                this.sectionEnd = this.sectionStart + 1;
                while (this.sectionEnd < allRegions.length && allRegions[this.sectionEnd].getStartOffset() == allRegions[this.sectionStart].getStartOffset()) {
                    ++this.sectionEnd;
                }
                this.current = this.sectionEnd;
            }

            @Override
            public boolean hasNext() {
                return this.current > this.sectionStart || this.sectionEnd < allRegions.length;
            }

            @Override
            public FoldRegion next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.current <= this.sectionStart) {
                    this.advanceSection();
                }
                return allRegions[--this.current];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

