/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithBlockSurrounder
extends JavaStatementsSurrounder {
    JavaWithBlockSurrounder() {
    }

    public String getTemplateDescription() {
        return "{ }";
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text = "{\n}";
        PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText(text, null);
        blockStatement = (PsiBlockStatement)codeStyleManager.reformat((PsiElement)blockStatement);
        blockStatement = (PsiBlockStatement)container.addBefore((PsiElement)blockStatement, statements[0]);
        PsiCodeBlock body = blockStatement.getCodeBlock();
        SurroundWithUtil.indentCommentIfNecessary(body, statements);
        body.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiElement firstChild = blockStatement.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        TextRange range = firstChild.getTextRange();
        return new TextRange(range.getEndOffset(), range.getEndOffset());
    }
}

