/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTemplateCallback {
    private static final Logger LOGGER = Logger.getInstance(CustomTemplateCallback.class);
    private final TemplateManager myTemplateManager;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    private final int myOffset;
    @NotNull
    private final Project myProject;
    private final boolean myInInjectedFragment;
    private Set<TemplateContextType> myApplicableContextTypes;

    public CustomTemplateCallback(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/CustomTemplateCallback", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/CustomTemplateCallback", "<init>"));
        }
        this.myProject = file.getProject();
        this.myTemplateManager = TemplateManager.getInstance(this.myProject);
        this.myOffset = CustomTemplateCallback.getOffset(editor);
        PsiElement element = InjectedLanguageUtil.findInjectedElementNoCommit(file, this.myOffset);
        this.myFile = element != null ? element.getContainingFile() : file;
        this.myInInjectedFragment = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(this.myFile);
        this.myEditor = this.myInInjectedFragment ? InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file, this.myOffset) : editor;
    }

    public TemplateManager getTemplateManager() {
        return this.myTemplateManager;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = CustomTemplateCallback.getContext(this.myFile, this.getOffset(), this.myInInjectedFragment);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        return psiElement;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public static int getOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/CustomTemplateCallback", "getOffset"));
        }
        return Math.max(editor.getSelectionModel().getSelectionStart() - 1, 0);
    }

    @Nullable
    public TemplateImpl findApplicableTemplate(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplate"));
        }
        return (TemplateImpl)ContainerUtil.getFirstItem(this.findApplicableTemplates(key));
    }

    @NotNull
    public List<TemplateImpl> findApplicableTemplates(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplates"));
        }
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : CustomTemplateCallback.getMatchingTemplates(key)) {
            if (!this.isAvailableTemplate(candidate)) continue;
            result2.add(candidate);
        }
        ArrayList<TemplateImpl> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplates"));
        }
        return arrayList;
    }

    private boolean isAvailableTemplate(@NotNull TemplateImpl template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/CustomTemplateCallback", "isAvailableTemplate"));
        }
        if (this.myApplicableContextTypes == null) {
            this.myApplicableContextTypes = TemplateManagerImpl.getApplicableContextTypes(this.myFile, this.myOffset);
        }
        return !template.isDeactivated() && TemplateManagerImpl.isApplicable(template, this.myApplicableContextTypes);
    }

    public void startTemplate(@NotNull Template template, Map<String, String> predefinedValues, TemplateEditingListener listener) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/CustomTemplateCallback", "startTemplate"));
        }
        if (this.myInInjectedFragment) {
            template.setToReformat(false);
        }
        this.myTemplateManager.startTemplate(this.myEditor, template, false, predefinedValues, listener);
    }

    @NotNull
    private static List<TemplateImpl> getMatchingTemplates(@NotNull String templateKey) {
        if (templateKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateKey", "com/intellij/codeInsight/template/CustomTemplateCallback", "getMatchingTemplates"));
        }
        TemplateSettings settings = TemplateSettings.getInstance();
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : settings.getTemplates(templateKey)) {
            if (template.isDeactivated()) continue;
            candidates.add(template);
        }
        ArrayList<TemplateImpl> arrayList = candidates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getMatchingTemplates"));
        }
        return arrayList;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFile.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getProject"));
        }
        return project;
    }

    public void deleteTemplateKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/CustomTemplateCallback", "deleteTemplateKey"));
        }
        int caretAt = this.myEditor.getCaretModel().getOffset();
        int templateStart = caretAt - key.length();
        this.myEditor.getDocument().deleteString(templateStart, caretAt);
        this.myEditor.getCaretModel().moveToOffset(templateStart);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        PsiElement psiElement = CustomTemplateCallback.getContext(file, offset, true);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file, int offset, boolean searchInInjectedFragment) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        PsiElement element = null;
        if (searchInInjectedFragment && !InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = documentManager.getDocument(file);
            if (document != null && !documentManager.isCommitted(document)) {
                LOGGER.error("Trying to access to injected template context on uncommited document, offset = " + offset, new Attachment[]{AttachmentFactory.createAttachment(file.getVirtualFile())});
            } else {
                element = InjectedLanguageUtil.findInjectedElementNoCommit(file, offset);
            }
        }
        if (element == null) {
            element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        return psiElement;
    }

    public boolean isInInjectedFragment() {
        return this.myInInjectedFragment;
    }
}

