/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetUpdateTagAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    private static final String EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY = "emmet.recent.update.abbreviations";
    private static final String EMMET_LAST_UPDATE_ABBREVIATIONS_KEY = "emmet.last.update.abbreviations";

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1", "invoke"));
                }
                final XmlTag tag = EmmetUpdateTagAction.findTag(editor, file);
                if (tag != null) {
                    new EmmetAbbreviationBalloon(EmmetUpdateTagAction.EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY, EmmetUpdateTagAction.EMMET_LAST_UPDATE_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

                        @Override
                        public void onEnter(@NotNull String abbreviation) {
                            if (abbreviation == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$1$1", "onEnter"));
                            }
                            try {
                                EmmetUpdateTagAction.this.doUpdateTag(abbreviation, tag, file, editor);
                            }
                            catch (EmmetException emmetException) {
                                // empty catch block
                            }
                        }
                    }, XmlBundle.message((String)"emmet.update.tag.title", (Object[])new Object[0])).show(new CustomTemplateCallback(editor, file));
                }
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    public void doUpdateTag(final @NotNull String abbreviation, @NotNull XmlTag tag, @NotNull PsiFile file, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTag"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTag"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTag"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTag"));
        }
        if (tag.isValid()) {
            String templateText = EmmetUpdateTagAction.expandTemplate(abbreviation, file, editor);
            final LinkedHashSet classNames = ContainerUtil.newLinkedHashSet();
            String classAttribute = tag.getAttributeValue("class");
            if (classAttribute != null) {
                ContainerUtil.addAll((Collection)classNames, (Iterable)StringUtil.tokenize((String)classAttribute, (String)" \t"));
            }
            final LinkedHashMap attributes = ContainerUtil.newLinkedHashMap();
            final Ref newTagName = Ref.create();
            EmmetUpdateTagAction.processTags(file.getProject(), templateText, new PairProcessor<XmlTag, Boolean>(){

                public boolean process(XmlTag tag, Boolean firstTag) {
                    if (firstTag.booleanValue() && !abbreviation.isEmpty() && StringUtil.isJavaIdentifierPart((char)abbreviation.charAt(0))) {
                        newTagName.set((Object)tag.getName());
                    }
                    for (String clazz : StringUtil.tokenize((String)StringUtil.notNullize((String)tag.getAttributeValue("class")), (String)" \t")) {
                        if (StringUtil.startsWithChar((CharSequence)clazz, (char)'+')) {
                            classNames.add(clazz.substring(1));
                            continue;
                        }
                        if (StringUtil.startsWithChar((CharSequence)clazz, (char)'-')) {
                            classNames.remove(clazz.substring(1));
                            continue;
                        }
                        classNames.clear();
                        classNames.add(clazz);
                    }
                    if (!firstTag.booleanValue()) {
                        classNames.add(tag.getName());
                    }
                    for (XmlAttribute xmlAttribute : tag.getAttributes()) {
                        if ("class".equalsIgnoreCase(xmlAttribute.getName())) continue;
                        attributes.put(xmlAttribute.getName(), StringUtil.notNullize((String)xmlAttribute.getValue()));
                    }
                    return true;
                }
            });
            EmmetUpdateTagAction.doUpdateTagAttributes(tag, file, (String)newTagName.get(), classNames, attributes).execute();
        }
    }

    @Nullable
    private static String expandTemplate(@NotNull String abbreviation, @NotNull PsiFile file, @NotNull Editor editor) throws EmmetException {
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "expandTemplate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "expandTemplate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "expandTemplate"));
        }
        CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file);
        ZenCodingTemplate.expand(abbreviation, callback, XmlZenCodingGeneratorImpl.INSTANCE, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        TemplateImpl template = callback.getGeneratedTemplate();
        return template != null ? template.getTemplateText() : null;
    }

    private static void processTags(@NotNull Project project, @Nullable String templateText, @NotNull PairProcessor<XmlTag, Boolean> processor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "processTags"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "processTags"));
        }
        if (StringUtil.isNotEmpty((String)templateText)) {
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
            XmlFile xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.HTML, (CharSequence)templateText);
            XmlTag tag = xmlFile.getRootTag();
            boolean firstTag = true;
            while (tag != null) {
                processor2.process((Object)tag, (Object)firstTag);
                firstTag = false;
                tag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            }
        }
    }

    @NotNull
    private static WriteCommandAction<Void> doUpdateTagAttributes(final @NotNull XmlTag tag, final @NotNull PsiFile file, final @Nullable String newTagName, final @NotNull Collection<String> classes, final @NotNull Map<String, String> attributes) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTagAttributes"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTagAttributes"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTagAttributes"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTagAttributes"));
        }
        WriteCommandAction<Void> writeCommandAction = new WriteCommandAction<Void>(file.getProject(), new PsiFile[]{file}){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction$3", "run"));
                }
                if (tag.isValid() && !ReadonlyStatusHandler.getInstance((Project)file.getProject()).ensureFilesWritable(new VirtualFile[]{file.getVirtualFile()}).hasReadonlyFiles()) {
                    tag.setAttribute("class", StringUtil.join((Collection)classes, (String)" ").trim());
                    for (Map.Entry attribute : attributes.entrySet()) {
                        XmlAttribute existingAttribute;
                        String attributeName = (String)attribute.getKey();
                        if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'+')) {
                            existingAttribute = tag.getAttribute(attributeName.substring(1));
                            if (existingAttribute != null) {
                                existingAttribute.setValue(StringUtil.notNullize((String)(existingAttribute.getValue() + (String)attribute.getValue())));
                                continue;
                            }
                            tag.setAttribute(attributeName.substring(1), (String)attribute.getValue());
                            continue;
                        }
                        if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'-')) {
                            existingAttribute = tag.getAttribute(attributeName.substring(1));
                            if (existingAttribute == null) continue;
                            existingAttribute.delete();
                            continue;
                        }
                        tag.setAttribute(attributeName, (String)attribute.getValue());
                    }
                    if (newTagName != null) {
                        tag.setName(newTagName);
                    }
                }
            }
        };
        if (writeCommandAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "doUpdateTagAttributes"));
        }
        return writeCommandAction;
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        event.getPresentation().setVisible(event.getPresentation().isEnabled());
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "isValidForFile"));
        }
        return super.isValidForFile(project, editor, file) && EmmetOptions.getInstance().isEmmetEnabled() && EmmetUpdateTagAction.findTag(editor, file) != null;
    }

    @Nullable
    private static XmlTag findTag(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "findTag"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetUpdateTagAction", "findTag"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), (Class[])new Class[]{XmlTag.class});
        return tag != null && HtmlUtil.isHtmlTag(tag) ? tag : null;
    }
}

