/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class PurityAnalysis {
    private static final Result<Key, Value> FINAL_TOP = new Final<Key, Value>(Value.Top);
    private static final Result<Key, Value> FINAL_PURE = new Final<Key, Value>(Value.Pure);
    static final int UN_ANALYZABLE_FLAG = 1792;

    @NotNull
    public static Equation<Key, Value> analyze(Method method, MethodNode methodNode, boolean stable) {
        Key key = new Key(method, Direction.Pure, stable);
        if ((methodNode.access & 0x700) != 0) {
            Equation<Key, Value> equation = new Equation<Key, Value>(key, FINAL_TOP);
            if (equation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/PurityAnalysis", "analyze"));
            }
            return equation;
        }
        InsnList insns = methodNode.instructions;
        HashSet<Key> invokedKeys = new HashSet<Key>();
        block5: for (int i = 0; i < insns.size(); ++i) {
            AbstractInsnNode insn = insns.get(i);
            switch (insn.getOpcode()) {
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 179: 
                case 181: 
                case 185: 
                case 186: {
                    Equation<Key, Value> equation = new Equation<Key, Value>(key, FINAL_TOP);
                    if (equation == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/PurityAnalysis", "analyze"));
                    }
                    return equation;
                }
                case 183: 
                case 184: {
                    invokedKeys.add(new Key(new Method((MethodInsnNode)insn), Direction.Pure, true));
                    continue block5;
                }
                case 182: {
                    invokedKeys.add(new Key(new Method((MethodInsnNode)insn), Direction.Pure, false));
                    continue block5;
                }
            }
        }
        if (invokedKeys.isEmpty()) {
            Equation<Key, Value> equation = new Equation<Key, Value>(key, FINAL_PURE);
            if (equation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/PurityAnalysis", "analyze"));
            }
            return equation;
        }
        HashSet sumOfProducts = new HashSet();
        for (Key call : invokedKeys) {
            sumOfProducts.add(new Product<Key, Value>(Value.Top, Collections.singleton(call)));
        }
        Equation<Key, Value> equation = new Equation<Key, Value>(key, new Pending(sumOfProducts));
        if (equation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/PurityAnalysis", "analyze"));
        }
        return equation;
    }
}

