/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextFormatter
implements InspectionsReportConverter {
    public static final String NAME = "plain";
    private static final String FILE_ELEMENT = "file";
    private static final String LINE_ELEMENT = "line";
    private static final String PROBLEM_ELEMENT = "problem";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    private static final String SEVERITY_ATTRIBUTE = "severity";

    @Override
    public String getFormatName() {
        return NAME;
    }

    @Override
    public boolean useTmpDirForRawData() {
        return true;
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        Writer w;
        Transformer transformer;
        if (rawDataDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawDataDirectoryPath", "com/intellij/codeInspection/ex/PlainTextFormatter", "convert"));
        }
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/codeInspection/ex/PlainTextFormatter", "convert"));
        }
        if (inspectionsResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionsResults", "com/intellij/codeInspection/ex/PlainTextFormatter", "convert"));
        }
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        URL descrExtractorXsltUrl = this.getClass().getResource("description-text.xsl");
        try {
            StreamSource xslSource = new StreamSource(URLUtil.openStream((URL)descrExtractorXsltUrl));
            transformer = transformerFactory.newTransformer(xslSource);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot find inspection descriptions converter.");
        }
        catch (TransformerConfigurationException e) {
            throw new InspectionsReportConverter.ConversionException("Fail to load inspection descriptions converter.");
        }
        if (outputPath != null) {
            File outputFile = new File(outputPath);
            try {
                w = new FileWriter(outputFile);
            }
            catch (IOException e) {
                throw new InspectionsReportConverter.ConversionException("Cannot edit file: " + outputFile.getPath());
            }
        } else {
            w = new PrintWriter(System.out);
        }
        try {
            for (File inspectionData : inspectionsResults) {
                if (inspectionData.isDirectory()) {
                    this.warn("Folder isn't expected here: " + inspectionData.getName());
                    continue;
                }
                String fileNameWithoutExt = FileUtil.getNameWithoutExtension((File)inspectionData);
                if (".descriptions".equals(fileNameWithoutExt)) continue;
                InspectionToolWrapper toolWrapper = tools.get(fileNameWithoutExt).getTool();
                w.append(this.getToolPresentableName(toolWrapper)).append("\n");
                this.writeInspectionDescription(w, toolWrapper, transformer);
                w.append("\n");
                SAXBuilder builder = new SAXBuilder();
                try {
                    Document doc = builder.build(inspectionData);
                    Element root = doc.getRootElement();
                    List problems = root.getChildren(PROBLEM_ELEMENT);
                    int maxFileColonLineLength = this.getMaxFileColonLineNumLength(inspectionData, toolWrapper, problems);
                    for (Object problem : problems) {
                        Element fileElement = ((Element)problem).getChild(FILE_ELEMENT);
                        String filePath = this.getPath(fileElement);
                        if (this.resultsIgnored(inspectionData, toolWrapper)) continue;
                        Element lineElement = ((Element)problem).getChild(LINE_ELEMENT);
                        Element problemDescrElement = ((Element)problem).getChild(DESCRIPTION_ELEMENT);
                        String severity = ((Element)problem).getChild(PROBLEM_CLASS_ELEMENT).getAttributeValue(SEVERITY_ATTRIBUTE);
                        String fileLineNum = lineElement.getText();
                        w.append("  ").append(filePath).append(':').append(fileLineNum);
                        for (int i = maxFileColonLineLength - 1 - filePath.length() - fileLineNum.length() + 4; i >= 0; --i) {
                            w.append(' ');
                        }
                        w.append("[").append(severity).append("] ");
                        w.append(problemDescrElement.getText()).append('\n');
                    }
                }
                catch (JDOMException e) {
                    throw new InspectionsReportConverter.ConversionException("Unknown results format, file = " + inspectionData.getPath() + ". Error: " + e.getMessage());
                }
                w.append("\n");
            }
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot write inspection results: " + e.getMessage());
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    this.warn("Cannot save inspection results: " + e.getMessage());
                }
            }
        }
    }

    private int getMaxFileColonLineNumLength(@NotNull File inspectionResultData, @NotNull InspectionToolWrapper toolWrapper, @NotNull List problems) {
        if (inspectionResultData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionResultData", "com/intellij/codeInspection/ex/PlainTextFormatter", "getMaxFileColonLineNumLength"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/PlainTextFormatter", "getMaxFileColonLineNumLength"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/ex/PlainTextFormatter", "getMaxFileColonLineNumLength"));
        }
        int maxFileColonLineLength = 0;
        for (Object problem : problems) {
            Element fileElement = ((Element)problem).getChild(FILE_ELEMENT);
            Element lineElement = ((Element)problem).getChild(LINE_ELEMENT);
            String filePath = this.getPath(fileElement);
            if (this.resultsIgnored(inspectionResultData, toolWrapper)) continue;
            maxFileColonLineLength = Math.max(maxFileColonLineLength, filePath.length() + 1 + lineElement.getText().length());
        }
        return maxFileColonLineLength;
    }

    private void warn(String msg) {
        System.err.println(msg);
    }

    private boolean resultsIgnored(@NotNull File file, @NotNull InspectionToolWrapper toolWrapper) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ELEMENT, "com/intellij/codeInspection/ex/PlainTextFormatter", "resultsIgnored"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/PlainTextFormatter", "resultsIgnored"));
        }
        return false;
    }

    @NotNull
    protected String getPath(@NotNull Element fileElement) {
        if (fileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "com/intellij/codeInspection/ex/PlainTextFormatter", "getPath"));
        }
        String string = fileElement.getText().replace("file://$PROJECT_DIR$", ".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/PlainTextFormatter", "getPath"));
        }
        return string;
    }

    protected void writeInspectionDescription(@NotNull Writer w, @NotNull InspectionToolWrapper toolWrapper, @NotNull Transformer transformer) throws IOException, InspectionsReportConverter.ConversionException {
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "com/intellij/codeInspection/ex/PlainTextFormatter", "writeInspectionDescription"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/PlainTextFormatter", "writeInspectionDescription"));
        }
        if (transformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "com/intellij/codeInspection/ex/PlainTextFormatter", "writeInspectionDescription"));
        }
        StringWriter descrWriter = new StringWriter();
        String descr = toolWrapper.loadDescription();
        if (descr == null) {
            return;
        }
        descr = descr.replace("<br>", "<br/>");
        try {
            transformer.transform(new StreamSource(new StringReader(descr)), new StreamResult(descrWriter));
        }
        catch (TransformerException e) {
            this.warn("ERROR:  Cannot load description for inspection: " + this.getToolPresentableName(toolWrapper) + ".\n        Error message: " + e.getMessage());
            return;
        }
        String trimmedDesc = descrWriter.toString().trim();
        String[] descLines = StringUtil.splitByLines((String)trimmedDesc);
        if (descLines.length > 0) {
            for (String descLine : descLines) {
                w.append("  ").append(descLine.trim()).append("\n");
            }
        }
    }

    @NotNull
    protected String getToolPresentableName(@NotNull InspectionToolWrapper toolWrapper) throws IOException {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/PlainTextFormatter", "getToolPresentableName"));
        }
        StringBuilder buff = new StringBuilder();
        buff.append(toolWrapper.getDisplayName()).append(" (");
        String[] groupPath = toolWrapper.getGroupPath();
        int groupPathLength = groupPath.length;
        for (int i = 0; i < groupPathLength; ++i) {
            if (i != 0) {
                buff.append(" | ");
            }
            buff.append(groupPath[i]);
        }
        buff.append(")");
        String string = buff.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/PlainTextFormatter", "getToolPresentableName"));
        }
        return string;
    }
}

