/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.artifacts.ArtifactsGenerator;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CleanProject
extends Generator {
    private final Target myTarget;

    public CleanProject(Project project, @NotNull GenerationOptions genOptions, @NotNull ArtifactsGenerator artifactsGenerator) {
        ModuleChunk[] chunks;
        if (genOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genOptions", "com/intellij/compiler/ant/CleanProject", "<init>"));
        }
        if (artifactsGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactsGenerator", "com/intellij/compiler/ant/CleanProject", "<init>"));
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        for (ModuleChunk moduleChunk : chunks = genOptions.getModuleChunks()) {
            dependencies.add(BuildProperties.getModuleCleanTargetName((String)moduleChunk.getName()));
        }
        dependencies.addAll(artifactsGenerator.getCleanTargetNames());
        for (ModuleChunk moduleChunk : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            dependencies.addAll(moduleChunk.getCleanTargetNames(project, genOptions));
        }
        this.myTarget = new Target("clean", StringUtil.join(dependencies, (String)", "), CompilerBundle.message((String)"generated.ant.build.clean.all.task.comment", (Object[])new Object[0]), null);
    }

    public void generate(PrintWriter out) throws IOException {
        this.myTarget.generate(out);
    }
}

