/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.api.index;

import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexConfigure;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexFeature;
import com.intellij.compiler.classFilesIndex.api.index.ClassFilesIndexReaderBase;
import com.intellij.compiler.classFilesIndex.api.index.ConfigureVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ClassFilesIndexFeaturesHolder
extends AbstractProjectComponent {
    private final Map<ClassFilesIndexConfigure, ClassFilesIndexReaderBase> myEnabledIndexReaders = new HashMap<ClassFilesIndexConfigure, ClassFilesIndexReaderBase>();
    private final Map<ClassFilesIndexFeature, FeatureState> myEnabledFeatures = new HashMap<ClassFilesIndexFeature, FeatureState>();

    public static ClassFilesIndexFeaturesHolder getInstance(Project project) {
        return (ClassFilesIndexFeaturesHolder)((Object)project.getComponent(ClassFilesIndexFeaturesHolder.class));
    }

    protected ClassFilesIndexFeaturesHolder(Project project) {
        super(project);
    }

    public final void projectOpened() {
        for (final ClassFilesIndexFeature feature : ClassFilesIndexFeature.values()) {
            RegistryValue registryValue = feature.getRegistryValue();
            registryValue.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

                public void afterValueChanged(RegistryValue rawValue) {
                    if (!rawValue.asBoolean() && ClassFilesIndexFeaturesHolder.this.myEnabledFeatures.containsKey((Object)feature)) {
                        ClassFilesIndexFeaturesHolder.this.disposeFeature(feature);
                    }
                }
            }, (Disposable)this.myProject);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                ClassFilesIndexFeaturesHolder.this.close();
                return true;
            }
        });
    }

    public synchronized boolean enableFeatureIfNeed(ClassFilesIndexFeature feature) {
        if (!feature.isEnabled()) {
            return false;
        }
        FeatureState state = this.myEnabledFeatures.get((Object)feature);
        if (state == null) {
            state = this.initializeFeature(feature);
        }
        return state == FeatureState.AVAILABLE;
    }

    public synchronized void visitConfigures(ConfigureVisitor visitor) {
        for (ClassFilesIndexConfigure configure : this.myEnabledIndexReaders.keySet()) {
            visitor.visit(configure, true);
        }
        for (ClassFilesIndexFeature feature : ClassFilesIndexFeature.values()) {
            if (!feature.isEnabled() || this.myEnabledFeatures.containsKey((Object)feature)) continue;
            for (ClassFilesIndexConfigure classFilesIndexConfigure : feature.getRequiredIndicesConfigures()) {
                if (this.myEnabledIndexReaders.containsKey(classFilesIndexConfigure)) continue;
                visitor.visit(classFilesIndexConfigure, false);
            }
        }
    }

    private synchronized void disposeFeature(ClassFilesIndexFeature featureToRemove) {
        for (ClassFilesIndexConfigure classFilesIndexConfigure : featureToRemove.getRequiredIndicesConfigures()) {
            boolean needClose = true;
            for (ClassFilesIndexFeature enabledFeature : this.myEnabledFeatures.keySet()) {
                if (enabledFeature.equals((Object)featureToRemove) || !enabledFeature.getRequiredIndicesConfigures().contains(classFilesIndexConfigure)) continue;
                needClose = false;
                break;
            }
            if (!needClose) continue;
            ClassFilesIndexReaderBase readerToClose = this.myEnabledIndexReaders.remove(classFilesIndexConfigure);
            readerToClose.close();
        }
        this.myEnabledFeatures.remove((Object)featureToRemove);
    }

    private synchronized FeatureState initializeFeature(ClassFilesIndexFeature feature) {
        if (this.myEnabledFeatures.containsKey((Object)feature)) {
            throw new IllegalStateException(String.format("feature %s already contains", feature.getKey()));
        }
        HashMap newIndices = new HashMap();
        FeatureState newFeatureState = FeatureState.AVAILABLE;
        for (ClassFilesIndexConfigure classFilesIndexConfigure : feature.getRequiredIndicesConfigures()) {
            boolean isIndexAlreadyLoaded = false;
            for (ClassFilesIndexFeature enabledFeature : this.myEnabledFeatures.keySet()) {
                if (!enabledFeature.getRequiredIndicesConfigures().contains(classFilesIndexConfigure)) continue;
                isIndexAlreadyLoaded = true;
                break;
            }
            if (isIndexAlreadyLoaded) continue;
            ClassFilesIndexReaderBase reader = classFilesIndexConfigure.createIndexReader(this.myProject);
            newIndices.put(classFilesIndexConfigure, reader);
            if (!reader.isEmpty()) continue;
            newFeatureState = FeatureState.NOT_AVAILABLE;
        }
        this.myEnabledIndexReaders.putAll(newIndices);
        this.myEnabledFeatures.put(feature, newFeatureState);
        return newFeatureState;
    }

    private synchronized void close() {
        for (ClassFilesIndexReaderBase reader : this.myEnabledIndexReaders.values()) {
            reader.close();
        }
        this.myEnabledIndexReaders.clear();
        this.myEnabledFeatures.clear();
    }

    public void projectClosed() {
        this.close();
    }

    @Nullable
    public <T extends ClassFilesIndexReaderBase> T getAvailableIndexReader(Class<T> tClass) {
        String indexReaderClassName = tClass.getCanonicalName();
        for (ClassFilesIndexReaderBase reader : this.myEnabledIndexReaders.values()) {
            if (!reader.getClass().getCanonicalName().equals(indexReaderClassName)) continue;
            return (T)reader;
        }
        throw new RuntimeException(String.format("index reader for class %s not found", indexReaderClassName));
    }

    public Project getProject() {
        return this.myProject;
    }

    private static enum FeatureState {
        AVAILABLE,
        NOT_AVAILABLE;

    }
}

