/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ApplicationStorageManager;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001da\u0001!G\u0001\u0019\u0002\u0005f\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0003\u0005\u0003!\u0011QB\u0001G\u00011\u000b\t6!\u0001\u0005\u0004K!!1\u0002c\u0004\u000e\u0003aA\u0011d\u0001E\t\u001b\u0005A\u0012\"K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001*\u0015\u0011Y\u0005\u0002c\u0002\u000e\u0003a!AdK)\u0004\u00075\u0011A\u0011\u0002\u0005\u0006S)!1\n\u0003E\u0006\u001b\u0005Ab!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f\u0001"}, strings={"Lcom/intellij/configurationStore/ApplicationStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "application", "Lcom/intellij/openapi/application/Application;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/components/PathMacroManager;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "storageManager", "Lcom/intellij/configurationStore/ApplicationStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ApplicationStorageManager;", "setPath", "", "path", ""}, moduleName="configuration-store-impl")
public final class ApplicationStoreImpl
extends ComponentStoreImpl {
    @NotNull
    private final ApplicationStorageManager storageManager;
    private final Application application;

    @Override
    @NotNull
    public ApplicationStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return this.application.isUnitTestMode() ? StateLoadPolicy.LOAD_ONLY_DEFAULT : StateLoadPolicy.LOAD;
    }

    @Override
    public void setPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.getStorageManager().addMacro("$APP_CONFIG$", path + "/" + ApplicationStorageManager.Companion.getFILE_STORAGE_DIR());
        this.getStorageManager().addMacro(SchemeManagerFactoryImplKt.getROOT_CONFIG(), path);
        VirtualFile configDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (configDir != null) {
            ActionsKt.invokeAndWaitIfNeed((Function0<? extends Unit>)((Function0)new Function0<Unit>(configDir){
                final /* synthetic */ VirtualFile $configDir;

                public final void invoke() {
                    boolean refreshAll = ServiceManagerImpl.isUseReadActionToInitService();
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)refreshAll, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$configDir});
                    VirtualFile optionsDir = this.$configDir.findChild(ApplicationStorageManager.Companion.getFILE_STORAGE_DIR());
                    if (!refreshAll && optionsDir != null) {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{optionsDir});
                    }
                }
                {
                    this.$configDir = virtualFile;
                    super(0);
                }
            }));
        }
    }

    public ApplicationStoreImpl(@NotNull Application application, @Nullable PathMacroManager pathMacroManager) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
        this.storageManager = new ApplicationStorageManager(this.application, pathMacroManager);
    }

    public /* synthetic */ ApplicationStoreImpl(Application application, PathMacroManager pathMacroManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pathMacroManager = null;
        }
        this(application, pathMacroManager);
    }
}

