/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFileTypeRegistry
extends FileTypeRegistry {
    private final Map<String, FileType> myExtensionsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
    private final List<FileType> myAllFileTypes = new ArrayList<FileType>();

    public CoreFileTypeRegistry() {
        this.myAllFileTypes.add(UnknownFileType.INSTANCE);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreFileTypeRegistry", "isFileIgnored"));
        }
        return false;
    }

    public FileType[] getRegisteredFileTypes() {
        return this.myAllFileTypes.toArray(new FileType[this.myAllFileTypes.size()]);
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
        }
        if (file instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file).getAssignedFileType()) != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
            }
            return fileType2;
        }
        FileType fileType3 = this.getFileTypeByFileName(file.getName());
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFile"));
        }
        return fileType3;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFileName"));
        }
        String extension = FileUtilRt.getExtension((String)fileName);
        FileType fileType = this.getFileTypeByExtension(extension);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByExtension"));
        }
        FileType result2 = this.myExtensionsMap.get(extension);
        FileType fileType = result2 == null ? UnknownFileType.INSTANCE : result2;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "getFileTypeByExtension"));
        }
        return fileType;
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/core/CoreFileTypeRegistry", "registerFileType"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/core/CoreFileTypeRegistry", "registerFileType"));
        }
        this.myAllFileTypes.add(fileType);
        for (String ext : extension.split(";")) {
            this.myExtensionsMap.put(ext, fileType);
        }
    }

    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/core/CoreFileTypeRegistry", "detectFileTypeFromContent"));
        }
        FileType fileType = UnknownFileType.INSTANCE;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreFileTypeRegistry", "detectFileTypeFromContent"));
        }
        return fileType;
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeName", "com/intellij/core/CoreFileTypeRegistry", "findFileTypeByName"));
        }
        for (FileType type : this.myAllFileTypes) {
            if (!type.getName().equals(fileTypeName)) continue;
            return type;
        }
        return null;
    }
}

