/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;

public abstract class GotoFrameSourceAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        GotoFrameSourceAction.doAction(dataContext);
    }

    protected static void doAction(DataContext dataContext) {
        SourcePosition sourcePosition;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        StackFrameDescriptorImpl stackFrameDescriptor = GotoFrameSourceAction.getStackFrameDescriptor(dataContext);
        if (stackFrameDescriptor != null && (sourcePosition = stackFrameDescriptor.getSourcePosition()) != null) {
            sourcePosition.navigate(true);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(GotoFrameSourceAction.getStackFrameDescriptor(e.getDataContext()) != null);
    }

    private static StackFrameDescriptorImpl getStackFrameDescriptor(DataContext dataContext) {
        DebuggerTreeNodeImpl selectedNode = GotoFrameSourceAction.getSelectedNode(dataContext);
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getDescriptor() == null || !(selectedNode.getDescriptor() instanceof StackFrameDescriptorImpl)) {
            return null;
        }
        return (StackFrameDescriptorImpl)selectedNode.getDescriptor();
    }
}

