/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class RemoteStateState
implements RemoteState {
    private final Project myProject;
    private final RemoteConnection myConnection;

    public RemoteStateState(Project project, RemoteConnection connection) {
        this.myProject = project;
        this.myConnection = connection;
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/debugger/engine/RemoteStateState", "execute"));
        }
        ConsoleViewImpl consoleView = new ConsoleViewImpl(this.myProject, false);
        RemoteDebugProcessHandler process = new RemoteDebugProcessHandler(this.myProject);
        consoleView.attachToProcess(process);
        return new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)process);
    }

    public RemoteConnection getRemoteConnection() {
        return this.myConnection;
    }
}

