/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerAdapter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapManager
extends AbstractProjectComponent {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap();
    private static final String CLASS_EXTENSION = ".class";

    public HotSwapManager(Project project, DebuggerManagerEx manager) {
        super(project);
        manager.addDebuggerManagerListener(new DebuggerManagerAdapter(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.put(session, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.remove(session);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("HotSwapManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/HotSwapManager", "getComponentName"));
        }
        return "HotSwapManager";
    }

    private long getTimeStamp(DebuggerSession session) {
        Long tStamp = this.myTimeStamps.get(session);
        return tStamp != null ? tStamp : 0L;
    }

    void setTimeStamp(DebuggerSession session, long tStamp) {
        this.myTimeStamps.put(session, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession session, final HotSwapProgress progress, boolean scanWithVFS) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        final long timeStamp = this.getTimeStamp(session);
        HashMap modifiedClasses = new HashMap();
        if (scanWithVFS) {
            ApplicationManager.getApplication().runReadAction(new Runnable((Map)modifiedClasses){
                final /* synthetic */ Map val$modifiedClasses;
                {
                    this.val$modifiedClasses = map;
                }

                @Override
                public void run() {
                    List allDirs = OrderEnumerator.orderEntries((Project)HotSwapManager.this.myProject).withoutSdk().withoutLibraries().getPathsList().getRootDirs();
                    CompilerPathsEx.visitFiles((Collection)allDirs, (CompilerPathsEx.FileVisitor)new CompilerPathsEx.FileVisitor(){

                        protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath) {
                            if (!progress.isCancelled()) {
                                progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
                                super.acceptDirectory(file, fileRoot, filePath);
                            }
                        }

                        protected void acceptFile(VirtualFile file, String fileRoot, String filePath) {
                            if (progress.isCancelled()) {
                                return;
                            }
                            if (file.getTimeStamp() > timeStamp && StdFileTypes.CLASS.equals(file.getFileType()) && (SystemInfo.isFileSystemCaseSensitive ? filePath.endsWith(HotSwapManager.CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)HotSwapManager.CLASS_EXTENSION))) {
                                progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
                                String qualifiedName = filePath.substring(fileRoot.length() + 1, filePath.length() - HotSwapManager.CLASS_EXTENSION.length()).replace('/', '.');
                                val$modifiedClasses.put(qualifiedName, new HotSwapFile(new File(filePath)));
                            }
                        }
                    });
                }
            });
        } else {
            final ArrayList outputRoots = new ArrayList();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    List allDirs = OrderEnumerator.orderEntries((Project)HotSwapManager.this.myProject).withoutSdk().withoutLibraries().getPathsList().getRootDirs();
                    for (VirtualFile dir : allDirs) {
                        outputRoots.add(new File(dir.getPath()));
                    }
                }
            });
            for (File root : outputRoots) {
                String rootPath = FileUtil.toCanonicalPath((String)root.getPath());
                HotSwapManager.collectModifiedClasses(root, rootPath, rootPath + "/", (Map<String, HotSwapFile>)modifiedClasses, progress, timeStamp);
            }
        }
        return modifiedClasses;
    }

    private static boolean collectModifiedClasses(File file, String filePath, String rootPath, Map<String, HotSwapFile> container, HotSwapProgress progress, long timeStamp) {
        if (progress.isCancelled()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (HotSwapManager.collectModifiedClasses(child, filePath + "/" + child.getName(), rootPath, container, progress, timeStamp)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)filePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)CLASS_EXTENSION)) && file.lastModified() > timeStamp) {
            progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
            String qualifiedName = filePath.substring(rootPath.length(), filePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
            container.put(qualifiedName, new HotSwapFile(file));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project) {
        return (HotSwapManager)((Object)project.getComponent(HotSwapManager.class));
    }

    private void reloadClasses(DebuggerSession session, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session, progress).reloadClasses(classesToReload);
        if (progress.isCancelled()) {
            session.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(session, newSwapTime);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<DebuggerSession> sessions, Map<String, List<String>> generatedPaths) {
        java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>> result2 = new java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> sessionWithStamps = new ArrayList<Pair>();
        for (DebuggerSession debuggerSession : sessions) {
            sessionWithStamps.add(new Pair((Object)debuggerSession, (Object)HotSwapManager.getInstance(debuggerSession.getProject()).getTimeStamp(debuggerSession)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File root = new File((String)entry.getKey());
            for (String relativePath : (List)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)relativePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)relativePath, (String)CLASS_EXTENSION))) continue;
                String qualifiedName = relativePath.substring(0, relativePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
                HotSwapFile hotswapFile = new HotSwapFile(new File(root, relativePath));
                long fileStamp = hotswapFile.file.lastModified();
                for (Pair pair : sessionWithStamps) {
                    DebuggerSession session = (DebuggerSession)pair.first;
                    if (fileStamp <= (Long)pair.second) continue;
                    java.util.HashMap<String, HotSwapFile> container = (java.util.HashMap<String, HotSwapFile>)result2.get(session);
                    if (container == null) {
                        container = new java.util.HashMap<String, HotSwapFile>();
                        result2.put(session, container);
                    }
                    container.put(qualifiedName, hotswapFile);
                }
            }
        }
        return result2;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<DebuggerSession> sessions, final HotSwapProgress swapProgress, final boolean scanWithVFS) {
        HashMap modifiedClasses = new HashMap();
        final MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(new Runnable(){

            @Override
            public void run() {
                scanClassesCommand.cancel();
            }
        });
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl((Map)modifiedClasses){
                final /* synthetic */ Map val$modifiedClasses;
                {
                    this.val$modifiedClasses = map;
                }

                @Override
                protected void action() throws Exception {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, swapProgress, scanWithVFS);
                    if (!sessionClasses.isEmpty()) {
                        this.val$modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession session : sessions) {
                session.setModifiedClassesScanRequired(true);
            }
            return new HashMap();
        }
        return modifiedClasses;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgress reloadClassesProgress) {
        final MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(new Runnable(){

            @Override
            public void run() {
                reloadClassesCommand.cancel();
            }
        });
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
    }
}

