/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecompiledLocalVariable {
    public static final Comparator<DecompiledLocalVariable> COMPARATOR = new Comparator<DecompiledLocalVariable>(){

        @Override
        public int compare(DecompiledLocalVariable v1, DecompiledLocalVariable v2) {
            return v1.getSlot() - v2.getSlot();
        }
    };
    private final int mySlot;
    private final String mySignature;
    private final boolean myIsParam;
    private final Collection<String> myMatchedNames;

    public DecompiledLocalVariable(int slot, boolean isParam, @Nullable String signature, @NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/debugger/jdi/DecompiledLocalVariable", "<init>"));
        }
        this.mySlot = slot;
        this.myIsParam = isParam;
        this.mySignature = signature;
        this.myMatchedNames = names;
    }

    public int getSlot() {
        return this.mySlot;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    public boolean isParam() {
        return this.myIsParam;
    }

    @NotNull
    public String getDefaultName() {
        String string = this.myIsParam ? "arg_" + this.mySlot : "slot_" + this.mySlot;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/DecompiledLocalVariable", "getDefaultName"));
        }
        return string;
    }

    public String getDisplayName() {
        String nameString = StringUtil.join(this.myMatchedNames, (String)" | ");
        if (this.myIsParam && this.myMatchedNames.size() == 1) {
            return nameString;
        }
        if (!this.myMatchedNames.isEmpty()) {
            return nameString + " (" + this.getDefaultName() + ")";
        }
        return this.getDefaultName();
    }

    @NotNull
    public Collection<String> getMatchedNames() {
        Collection<String> collection = this.myMatchedNames;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/DecompiledLocalVariable", "getMatchedNames"));
        }
        return collection;
    }

    public String toString() {
        return this.getDisplayName() + " (slot " + this.mySlot + ", " + this.mySignature + ")";
    }
}

