/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDescriptorImpl
extends ValueDescriptorImpl
implements LocalVariableDescriptor {
    private final StackFrameProxyImpl myFrameProxy;
    private final LocalVariableProxyImpl myLocalVariable;
    private String myTypeName;
    private boolean myIsPrimitive;
    private boolean myIsNewLocal;

    public LocalVariableDescriptorImpl(Project project, @NotNull LocalVariableProxyImpl local) {
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl", "<init>"));
        }
        super(project);
        this.myTypeName = DebuggerBundle.message((String)"label.unknown.value", (Object[])new Object[0]);
        this.myIsNewLocal = true;
        this.setLvalue(true);
        this.myFrameProxy = local.getFrame();
        this.myLocalVariable = local;
    }

    @Override
    public LocalVariableProxyImpl getLocalVariable() {
        return this.myLocalVariable;
    }

    public boolean isNewLocal() {
        return this.myIsNewLocal;
    }

    @Override
    public boolean isPrimitive() {
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        boolean isVisible = this.myFrameProxy.isLocalVariableVisible(this.getLocalVariable());
        if (isVisible) {
            String typeName;
            this.myTypeName = typeName = this.getLocalVariable().typeName();
            this.myIsPrimitive = DebuggerUtils.isPrimitiveType((String)typeName);
            return this.myFrameProxy.getValue(this.getLocalVariable());
        }
        return null;
    }

    public void setNewLocal(boolean aNew) {
        this.myIsNewLocal = aNew;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        super.displayAs(descriptor);
        if (descriptor instanceof LocalVariableDescriptorImpl) {
            this.myIsNewLocal = ((LocalVariableDescriptorImpl)descriptor).myIsNewLocal;
        }
    }

    @Override
    public String getName() {
        return this.myLocalVariable.name();
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.myLocalVariable.typeName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

