/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.BatchEvaluatorServer;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BatchEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BatchEvaluator");
    private final DebugProcess myDebugProcess;
    private boolean myBatchEvaluatorChecked;
    private ObjectReference myBatchEvaluatorObject;
    private Method myBatchEvaluatorMethod;
    private static final Key<BatchEvaluator> BATCH_EVALUATOR_KEY = new Key("BatchEvaluator");
    public static final Key<Boolean> REMOTE_SESSION_KEY = new Key("is_remote_session_key");
    private final HashMap<SuspendContext, List<ToStringCommand>> myBuffer = new HashMap();

    private BatchEvaluator(DebugProcess process) {
        this.myDebugProcess = process;
        this.myDebugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapter(){

            public void processDetached(DebugProcess process, boolean closedByUser) {
                BatchEvaluator.this.myBatchEvaluatorChecked = false;
                BatchEvaluator.this.myBatchEvaluatorObject = null;
                BatchEvaluator.this.myBatchEvaluatorMethod = null;
            }
        });
    }

    public boolean hasBatchEvaluator(EvaluationContext evaluationContext) {
        if (!this.myBatchEvaluatorChecked) {
            Method constructor;
            this.myBatchEvaluatorChecked = true;
            Boolean isRemote = (Boolean)this.myDebugProcess.getUserData(REMOTE_SESSION_KEY);
            if (isRemote != null && isRemote.booleanValue()) {
                return false;
            }
            ThreadReferenceProxy thread = evaluationContext.getSuspendContext().getThread();
            if (thread == null) {
                return false;
            }
            ThreadReference threadReference = thread.getThreadReference();
            if (threadReference == null) {
                return false;
            }
            ClassType batchEvaluatorClass = null;
            try {
                batchEvaluatorClass = (ClassType)this.myDebugProcess.findClass(evaluationContext, BatchEvaluatorServer.class.getName(), evaluationContext.getClassLoader());
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (batchEvaluatorClass != null && (constructor = batchEvaluatorClass.concreteMethodByName("<init>", "()V")) != null) {
                ObjectReference evaluator = null;
                try {
                    evaluator = this.myDebugProcess.newInstance(evaluationContext, batchEvaluatorClass, constructor, Collections.emptyList());
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
                this.myBatchEvaluatorObject = evaluator;
                if (this.myBatchEvaluatorObject != null) {
                    this.myBatchEvaluatorMethod = batchEvaluatorClass.concreteMethodByName("evaluate", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                }
            }
        }
        return this.myBatchEvaluatorMethod != null;
    }

    public void invoke(ToStringCommand command) {
        LOG.assertTrue(DebuggerManager.getInstance((Project)this.myDebugProcess.getProject()).isDebuggerManagerThread());
        final EvaluationContext evaluationContext = command.getEvaluationContext();
        final SuspendContext suspendContext = evaluationContext.getSuspendContext();
        if (!Registry.is((String)"debugger.batch.evaluation") || !this.hasBatchEvaluator(evaluationContext)) {
            this.myDebugProcess.getManagerThread().invokeCommand((DebuggerCommand)command);
        } else {
            ArrayList<ToStringCommand> toStringCommands = (ArrayList<ToStringCommand>)this.myBuffer.get((Object)suspendContext);
            if (toStringCommands == null) {
                ArrayList<ToStringCommand> commands;
                toStringCommands = commands = new ArrayList<ToStringCommand>();
                this.myBuffer.put((Object)suspendContext, commands);
                this.myDebugProcess.getManagerThread().invokeCommand((DebuggerCommand)new SuspendContextCommand(){

                    public SuspendContext getSuspendContext() {
                        return suspendContext;
                    }

                    public void action() {
                        BatchEvaluator.this.myBuffer.remove((Object)suspendContext);
                        if (!BatchEvaluator.this.doEvaluateBatch(commands, evaluationContext)) {
                            for (ToStringCommand toStringCommand : commands) {
                                toStringCommand.action();
                            }
                        }
                    }

                    public void commandCancelled() {
                        BatchEvaluator.this.myBuffer.remove((Object)suspendContext);
                    }
                });
            }
            toStringCommands.add(command);
        }
    }

    public static BatchEvaluator getBatchEvaluator(DebugProcess debugProcess) {
        BatchEvaluator batchEvaluator = (BatchEvaluator)debugProcess.getUserData(BATCH_EVALUATOR_KEY);
        if (batchEvaluator == null) {
            batchEvaluator = new BatchEvaluator(debugProcess);
            debugProcess.putUserData(BATCH_EVALUATOR_KEY, (Object)batchEvaluator);
        }
        return batchEvaluator;
    }

    private boolean doEvaluateBatch(List<ToStringCommand> requests, EvaluationContext evaluationContext) {
        try {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            ArrayList<Value> values = new ArrayList<Value>();
            for (ToStringCommand toStringCommand : requests) {
                Value value = toStringCommand.getValue();
                values.add(value instanceof ObjectReference ? (ObjectReference)value : value);
            }
            ArrayType objectArrayClass = (ArrayType)debugProcess.findClass(evaluationContext, "java.lang.Object[]", evaluationContext.getClassLoader());
            if (objectArrayClass == null) {
                return false;
            }
            ArrayReference argArray = debugProcess.newInstance(objectArrayClass, values.size());
            ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep(argArray);
            argArray.setValues(values);
            ArrayList<ArrayReference> argList = new ArrayList<ArrayReference>(1);
            argList.add(argArray);
            Value value = debugProcess.invokeMethod(evaluationContext, this.myBatchEvaluatorObject, this.myBatchEvaluatorMethod, argList);
            if (value instanceof ArrayReference) {
                ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep((ArrayReference)value);
                ArrayReference strings = (ArrayReference)value;
                List<Value> allValuesArray = strings.getValues();
                Value[] allValues = allValuesArray.toArray(new Value[allValuesArray.size()]);
                int idx = 0;
                for (ToStringCommand request : requests) {
                    Value strValue = allValues[idx];
                    if (strValue == null || strValue instanceof StringReference) {
                        try {
                            String str = strValue == null ? null : ((StringReference)strValue).value();
                            request.evaluationResult(str);
                        }
                        catch (ObjectCollectedException objectCollectedException) {}
                    } else if (strValue instanceof ObjectReference) {
                        request.evaluationError(EvaluateExceptionUtil.createEvaluateException((Throwable)new InvocationException((ObjectReference)strValue)).getMessage());
                    } else {
                        LOG.assertTrue(false);
                    }
                    request.setEvaluated();
                    ++idx;
                }
            }
            return true;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
        }
        catch (InvalidTypeException invalidTypeException) {
        }
        catch (EvaluateException evaluateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }
}

