/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.Developer;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.errordialog.DeveloperRenderer;
import com.intellij.diagnostic.errordialog.LabeledTextComponent;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nullable;

public class DetailsTabForm {
    private JTextArea myDetailsPane;
    private JPanel myContentPane;
    private LabeledTextComponent myCommentsArea;
    private JPanel myDetailsHolder;
    private JButton myAnalyzeStacktraceButton;
    private JComboBox myAssigneeComboBox;
    private JPanel myAssigneePanel;
    private Integer myAssigneeId;
    private boolean myProcessEvents = true;

    public DetailsTabForm(@Nullable Action analyzeAction, boolean internalMode) {
        this.$$$setupUI$$$();
        this.myCommentsArea.setTitle(DiagnosticBundle.message("error.dialog.comment.prompt", new Object[0]));
        this.myDetailsPane.setBackground(UIUtil.getTextFieldBackground());
        this.myDetailsHolder.setPreferredSize(new Dimension(670, internalMode ? 500 : 205));
        this.myDetailsHolder.setBorder(IdeBorderFactory.createBorder());
        if (analyzeAction != null) {
            this.myAnalyzeStacktraceButton.setAction(analyzeAction);
        } else {
            this.myAnalyzeStacktraceButton.setVisible(false);
        }
        this.myAssigneeComboBox.setRenderer(new DeveloperRenderer(this.myAssigneeComboBox.getRenderer()));
        this.myAssigneeComboBox.setPrototypeDisplayValue(new Developer(0, "Here Goes Some Very Long String"));
        this.myAssigneeComboBox.addActionListener(new ActionListenerProxy(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsTabForm.this.myAssigneeId = DetailsTabForm.this.getAssigneeId();
            }
        }));
        new ComboboxSpeedSearch(this.myAssigneeComboBox){

            @Override
            protected String getElementText(Object element) {
                return element == null ? "" : ((Developer)element).getSearchableText();
            }
        };
    }

    public void setCommentsAreaVisible(boolean b) {
        this.myCommentsArea.getContentPane().setVisible(b);
    }

    public void setDetailsText(String s) {
        LabeledTextComponent.setText(this.myDetailsPane, s, false);
    }

    public void setCommentsText(String s) {
        LabeledTextComponent.setText(this.myCommentsArea.getTextComponent(), s, true);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myCommentsArea.getContentPane().isVisible()) {
            return this.myCommentsArea.getTextComponent();
        }
        return null;
    }

    public void setCommentsTextEnabled(boolean b) {
        if (this.myCommentsArea.getContentPane().isVisible()) {
            this.myCommentsArea.getTextComponent().setEnabled(b);
        }
    }

    public void addCommentsListener(LabeledTextComponent.TextListener l) {
        this.myCommentsArea.addCommentsListener(l);
    }

    public void setAssigneeVisible(boolean visible) {
        this.myAssigneePanel.setVisible(visible);
    }

    public void setDevelopers(Collection<Developer> developers) {
        this.myAssigneeComboBox.setModel(new DefaultComboBoxModel<Object>(developers.toArray()));
        this.updateSelectedDeveloper();
    }

    public void setAssigneeId(@Nullable Integer assigneeId) {
        this.myAssigneeId = assigneeId;
        if (this.myAssigneeComboBox.getItemCount() > 0) {
            this.updateSelectedDeveloper();
        }
    }

    private void updateSelectedDeveloper() {
        this.myProcessEvents = false;
        Integer index = null;
        for (int i = 0; i < this.myAssigneeComboBox.getItemCount(); ++i) {
            Developer developer = (Developer)this.myAssigneeComboBox.getItemAt(i);
            if (!ComparatorUtil.equalsNullable((Object)developer.getId(), (Object)this.myAssigneeId)) continue;
            index = i;
            break;
        }
        this.setSelectedAssigneeIndex(index);
        this.myProcessEvents = true;
    }

    private void setSelectedAssigneeIndex(Integer index) {
        if (index == null) {
            this.myAssigneeComboBox.setSelectedItem(null);
        } else {
            this.myAssigneeComboBox.setSelectedIndex(index);
        }
    }

    @Nullable
    public Integer getAssigneeId() {
        Developer assignee = (Developer)this.myAssigneeComboBox.getSelectedItem();
        return assignee == null ? null : assignee.getId();
    }

    public void addAssigneeListener(ActionListener listener) {
        this.myAssigneeComboBox.addActionListener(new ActionListenerProxy(listener));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JButton jButton;
        JTextArea jTextArea;
        JPanel jPanel2;
        LabeledTextComponent labeledTextComponent;
        JPanel jPanel3;
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myCommentsArea = labeledTextComponent = new LabeledTextComponent();
        JComponent jComponent = labeledTextComponent.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 150), null));
        this.myDetailsHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(32);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDetailsPane = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jBScrollPane.setViewportView(jTextArea);
        this.myAnalyzeStacktraceButton = jButton = new JButton();
        jButton.setText("Analyze Stacktrace");
        jPanel3.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myAssigneePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Assignee:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAssigneeComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class ActionListenerProxy
    implements ActionListener {
        private final ActionListener myDelegate;

        public ActionListenerProxy(ActionListener delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DetailsTabForm.this.myProcessEvents) {
                this.myDelegate.actionPerformed(e);
            }
        }
    }
}

